/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.LocalInvocation;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.RetryOnFailureXSiteCommand;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferCollector;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@Listener
public class XSiteStateTransferManagerImpl
implements XSiteStateTransferManager {
    private static final Log log = LogFactory.getLog(XSiteStateTransferManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean debug = log.isDebugEnabled();
    @Inject
    private RpcManager rpcManager;
    @Inject
    private Configuration configuration;
    @Inject
    private CommandsFactory commandsFactory;
    @Inject
    private ResponseGenerator responseGenerator;
    @Inject
    @ComponentName(value="org.infinispan.executors.transport")
    private ExecutorService asyncExecutor;
    @Inject
    private StateTransferManager stateTransferManager;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private CacheNotifier cacheNotifier;
    @Inject
    private XSiteStateConsumer consumer;
    @Inject
    private XSiteStateProvider provider;
    private final ConcurrentMap<String, XSiteStateTransferCollector> siteCollector = CollectionFactory.makeConcurrentMap();
    private final ConcurrentMap<String, String> status = CollectionFactory.makeConcurrentMap();

    @Start
    public void addListener() {
        this.cacheNotifier.addListener(this);
    }

    @Stop
    public void removeListener() {
        this.cacheNotifier.removeListener(this);
    }

    @Override
    public void notifyStatePushFinished(String siteName, Address node, boolean statusOk) throws Throwable {
        XSiteStateTransferCollector collector = (XSiteStateTransferCollector)this.siteCollector.get(siteName);
        if (collector == null) {
            return;
        }
        XSiteBackup xSiteBackup = this.findSite(siteName);
        if (collector.confirmStateTransfer(node, statusOk)) {
            this.siteCollector.remove(siteName);
            this.status.put(siteName, collector.isStatusOk() ? "OK" : "ERROR");
            this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CANCEL_SEND, siteName);
            this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.FINISH_RECEIVE, this.backupRpcConfiguration(siteName));
        }
    }

    @Override
    public final void startPushState(String siteName) throws Throwable {
        if (siteName == null) {
            throw new NullPointerException("Site name cannot be null!");
        }
        XSiteBackup xSiteBackup = this.findSite(siteName);
        if (xSiteBackup == null) {
            throw new IllegalArgumentException("Site " + siteName + " not found!");
        }
        if (this.siteCollector.putIfAbsent(siteName, new XSiteStateTransferCollector(this.rpcManager.getMembers())) != null) {
            throw new Exception(String.format("X-Site state transfer to '%s' already started!", siteName));
        }
        this.status.remove(siteName);
        try {
            this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.START_RECEIVE, null);
            if (!this.stateTransferManager.isStateTransferInProgress()) {
                this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.START_SEND, siteName);
            } else if (debug) {
                log.debugf("Not start sending keys to site '%s' while rebalance in progress. Wait until it is finished!", siteName);
            }
        }
        catch (Throwable throwable) {
            this.handleFailure(xSiteBackup);
            throw new Exception(throwable);
        }
    }

    @Override
    public List<String> getRunningStateTransfers() {
        return this.siteCollector.isEmpty() ? Collections.emptyList() : new ArrayList(this.siteCollector.keySet());
    }

    @Override
    public Map<String, String> getStatus() {
        return this.status.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(this.status);
    }

    @Override
    public void clearStatus() {
        this.status.clear();
    }

    @Override
    public void cancelPushState(String siteName) throws Throwable {
        if (!this.siteCollector.containsKey(siteName)) {
            if (trace) {
                log.tracef("Tried to cancel push state to '%s' but it does not exist.", siteName);
            }
            return;
        }
        XSiteBackup xSiteBackup = this.findSite(siteName);
        if (xSiteBackup == null) {
            throw new IllegalArgumentException("Site " + siteName + " not found!");
        }
        this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CANCEL_SEND, siteName);
        this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.FINISH_RECEIVE, null);
        this.siteCollector.remove(siteName);
        this.status.put(siteName, "CANCELED");
    }

    @Override
    public Map<String, String> getClusterStatus() throws Exception {
        XSiteStateTransferControlCommand command = this.commandsFactory.buildXSiteStateTransferControlCommand(XSiteStateTransferControlCommand.StateTransferControl.STATUS_REQUEST, null);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Response response : this.invokeRemotelyInLocalSite(command).values()) {
            if (!(response instanceof SuccessfulResponse)) continue;
            result.putAll((Map)((SuccessfulResponse)response).getResponseValue());
        }
        return result;
    }

    @Override
    public void clearClusterStatus() throws Exception {
        this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CLEAR_STATUS, null);
    }

    @Override
    public String getSendingSiteName() {
        return this.consumer.getSendingSiteName();
    }

    @Override
    public void cancelReceive(String siteName) throws Exception {
        this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.FINISH_RECEIVE, siteName);
    }

    @Override
    public void becomeCoordinator(String siteName) {
        this.startCoordinating(Collections.singleton(siteName), this.rpcManager.getMembers());
        if (this.stateTransferManager.isStateTransferInProgress()) {
            try {
                log.debugf("Canceling x-site state transfer for site %s", siteName);
                this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CANCEL_SEND, siteName);
            }
            catch (Exception e) {
                log.debugf(e, "Unable to cancel x-site state transfer for site %s", siteName);
            }
        } else {
            log.debugf("Restarting x-site state transfer for site %s", siteName);
            try {
                this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.RESTART_SEND, siteName);
            }
            catch (Exception e) {
                log.failedToRestartXSiteStateTransfer(siteName, e);
            }
        }
    }

    @TopologyChanged
    public <K, V> void handleTopology(TopologyChangedEvent<K, V> topologyChangedEvent) {
        if (debug) {
            log.debugf("Topology change detected! %s", topologyChangedEvent);
        }
        if (topologyChangedEvent.isPre()) {
            return;
        }
        List<Address> newMembers = topologyChangedEvent.getConsistentHashAtEnd().getMembers();
        boolean amINewCoordinator = newMembers.get(0).equals(this.rpcManager.getAddress());
        Collection<String> missingCoordinatorSites = this.provider.getSitesMissingCoordinator(new HashSet<Address>(newMembers));
        if (amINewCoordinator) {
            this.startCoordinating(missingCoordinatorSites, newMembers);
        }
        if (this.stateTransferManager.isStateTransferInProgress()) {
            for (String string : this.siteCollector.keySet()) {
                try {
                    log.debugf("Topology change detected! Canceling x-site state transfer for site %s", string);
                    this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CANCEL_SEND, string);
                }
                catch (Exception e) {
                    log.debugf(e, "Unable to cancel x-site state transfer for site %s", string);
                }
            }
        } else {
            for (Map.Entry entry : this.siteCollector.entrySet()) {
                entry.setValue(new XSiteStateTransferCollector(newMembers));
                log.debugf("Topology change detected! Restarting x-site state transfer for site %s", entry.getKey());
                try {
                    this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.RESTART_SEND, (String)entry.getKey());
                }
                catch (Exception e) {
                    log.failedToRestartXSiteStateTransfer((String)entry.getKey(), e);
                }
            }
        }
    }

    private void startCoordinating(Collection<String> sitesName, Collection<Address> members) {
        if (debug) {
            log.debugf("Becoming the x-site state transfer coordinator for %s", sitesName);
        }
        for (String siteName : sitesName) {
            if (siteName == null) {
                throw new NullPointerException("Site name cannot be null!");
            }
            XSiteBackup xSiteBackup = this.findSite(siteName);
            if (xSiteBackup == null) {
                throw new IllegalArgumentException("Site " + siteName + " not found!");
            }
            this.siteCollector.putIfAbsent(siteName, new XSiteStateTransferCollector(members));
        }
    }

    private void handleFailure(XSiteBackup xSiteBackup) {
        block6: {
            block5: {
                if (debug) {
                    log.debugf("Handle start state transfer failure to %s", xSiteBackup.getSiteName());
                }
                this.siteCollector.remove(xSiteBackup.getSiteName());
                try {
                    this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CANCEL_SEND, xSiteBackup.getSiteName());
                }
                catch (Exception e) {
                    if (!debug) break block5;
                    log.debugf(e, "Exception while cancel sending to remote site %s", xSiteBackup.getSiteName());
                }
            }
            try {
                this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.FINISH_RECEIVE, null);
            }
            catch (Throwable throwable) {
                if (!debug) break block6;
                log.debugf(throwable, "Exception while cancel receiving in remote site %s", xSiteBackup.getSiteName());
            }
        }
    }

    private void controlStateTransferOnRemoteSite(XSiteBackup xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl control, BackupRpcConfiguration backupRpcConfiguration) throws Throwable {
        XSiteStateTransferControlCommand command = this.commandsFactory.buildXSiteStateTransferControlCommand(control, null);
        RetryOnFailureXSiteCommand.RetryPolicy retryPolicy = backupRpcConfiguration == null ? RetryOnFailureXSiteCommand.NO_RETRY : new RetryOnFailureXSiteCommand.MaxRetriesPolicy(backupRpcConfiguration.maxRetries);
        long waitTime = backupRpcConfiguration == null ? 1L : backupRpcConfiguration.waitTime;
        RetryOnFailureXSiteCommand remoteSite = RetryOnFailureXSiteCommand.newInstance(xSiteBackup, command, retryPolicy);
        remoteSite.execute(this.rpcManager.getTransport(), waitTime, TimeUnit.MILLISECONDS);
    }

    private void controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl control, String siteName) throws Exception {
        XSiteStateTransferControlCommand command = this.commandsFactory.buildXSiteStateTransferControlCommand(control, siteName);
        command.setTopologyId(this.currentTopologyId());
        for (Map.Entry<Address, Response> entry : this.invokeRemotelyInLocalSite(command).entrySet()) {
            if (!(entry.getValue() instanceof ExceptionResponse)) continue;
            throw ((ExceptionResponse)entry.getValue()).getException();
        }
    }

    private int currentTopologyId() {
        return this.distributionManager.getCacheTopology().getTopologyId();
    }

    private XSiteBackup findSite(String siteName) {
        SitesConfiguration sites = this.configuration.sites();
        for (BackupConfiguration bc : sites.allBackups()) {
            if (!bc.site().equals(siteName)) continue;
            return new XSiteBackup(bc.site(), true, bc.stateTransfer().timeout());
        }
        return null;
    }

    private BackupRpcConfiguration backupRpcConfiguration(String siteName) {
        SitesConfiguration sites = this.configuration.sites();
        for (BackupConfiguration bc : sites.allBackups()) {
            if (!bc.site().equals(siteName)) continue;
            return new BackupRpcConfiguration(bc.stateTransfer().waitTime(), bc.stateTransfer().maxRetries());
        }
        return null;
    }

    private Map<Address, Response> invokeRemotelyInLocalSite(CacheRpcCommand command) throws Exception {
        this.commandsFactory.initializeReplicableCommand(command, false);
        CompletionStage<Map<Address, Response>> remoteFuture = this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        Future<Response> localFuture = this.asyncExecutor.submit(LocalInvocation.newInstance(this.responseGenerator, command, this.commandsFactory, this.rpcManager.getAddress()));
        Map<Address, Response> responseMap = this.rpcManager.blocking(remoteFuture);
        responseMap.put(this.rpcManager.getAddress(), localFuture.get());
        return responseMap;
    }

    private static class BackupRpcConfiguration {
        private final long waitTime;
        private final int maxRetries;

        private BackupRpcConfiguration(long waitTime, int maxRetries) {
            this.waitTime = waitTime;
            this.maxRetries = maxRetries;
        }
    }
}

