/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossExecutors;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class RemoveOnCancelScheduledExecutorServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
Function<ScheduledExecutorService, ScheduledExecutorService>,
Supplier<ScheduledExecutorService>,
Consumer<ScheduledExecutorService> {
    private final ThreadFactory factory;
    private volatile int size = 1;

    public RemoveOnCancelScheduledExecutorServiceConfigurator(ServiceName name, ThreadFactory factory) {
        super(name);
        this.factory = factory;
    }

    @Override
    public ScheduledExecutorService apply(ScheduledExecutorService executor) {
        return JBossExecutors.protectedScheduledExecutorService((ScheduledExecutorService)executor);
    }

    @Override
    public ScheduledExecutorService get() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.size, this.factory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    @Override
    public void accept(ScheduledExecutorService executor) {
        executor.shutdownNow();
    }

    @Override
    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder<?> builder = new AsyncServiceConfigurator(this.getServiceName()).startSynchronously().build(target);
        Consumer executor = builder.provides(new ServiceName[]{this.getServiceName()});
        FunctionalService<ScheduledExecutorService, ScheduledExecutorService> service = new FunctionalService<ScheduledExecutorService, ScheduledExecutorService>(executor, this, this, this);
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RemoveOnCancelScheduledExecutorServiceConfigurator size(int size) {
        this.size = size;
        return this;
    }
}

