/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.cluster.qourum.SharedNothingBackupQuorum;

public abstract class LiveNodeLocator
implements ClusterTopologyListener {
    private SharedNothingBackupQuorum backupQuorum;

    public LiveNodeLocator(SharedNothingBackupQuorum backupQuorum) {
        this.backupQuorum = backupQuorum;
    }

    public LiveNodeLocator() {
    }

    public abstract void locateNode(long var1) throws ActiveMQException;

    public abstract void locateNode() throws ActiveMQException;

    public abstract Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration();

    public abstract String getNodeID();

    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        if (this.backupQuorum != null) {
            if (alreadyReplicating) {
                this.backupQuorum.notifyAlreadyReplicating();
            } else {
                this.backupQuorum.notifyRegistrationFailed();
            }
        }
    }

    public void connectToCluster(ServerLocatorInternal serverLocator) throws ActiveMQException {
        serverLocator.connect();
    }
}

