/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.Configuration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.AddShutdownHookAction;
import org.wildfly.security.manager.action.GetModuleClassLoaderAction;

class SecurityActions {
    SecurityActions() {
    }

    static void addShutdownHook(Thread hook) {
        if (!WildFlySecurityManager.isChecking()) {
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            AccessController.doPrivileged(new AddShutdownHookAction(hook));
        }
    }

    static <T> T loadAndInstantiateFromClassClassLoader(final Class<?> base, final Class<T> iface, final String name) throws Exception {
        if (!WildFlySecurityManager.isChecking()) {
            return SecurityActions.internalLoadAndInstantiateFromClassClassLoader(base, iface, name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return SecurityActions.internalLoadAndInstantiateFromClassClassLoader(base, iface, name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Exception(t);
        }
    }

    private static <T> T internalLoadAndInstantiateFromClassClassLoader(Class<?> base, Class<T> iface, String name) throws Exception {
        ClassLoader cl = base.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Class<?> clazz = cl.loadClass(name);
        return iface.cast(clazz.newInstance());
    }

    static <T> T loadAndInstantiateFromModule(final String moduleId, final Class<T> iface, final String name) throws Exception {
        if (!WildFlySecurityManager.isChecking()) {
            return SecurityActions.internalLoadAndInstantiateFromModule(moduleId, iface, name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return SecurityActions.internalLoadAndInstantiateFromModule(moduleId, iface, name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Exception(t);
        }
    }

    private static <T> T internalLoadAndInstantiateFromModule(String moduleId, Class<T> iface, String name) throws Exception {
        ModuleLoader loader = Module.getCallerModuleLoader();
        Module module = loader.loadModule(ModuleIdentifier.fromString((String)moduleId));
        ModuleClassLoader cl = WildFlySecurityManager.isChecking() ? (ClassLoader)AccessController.doPrivileged(new GetModuleClassLoaderAction(module)) : module.getClassLoader();
        Class<?> clazz = cl.loadClass(name);
        return iface.cast(clazz.newInstance());
    }

    static Configuration getGlobalJaasConfiguration() throws SecurityException {
        if (!WildFlySecurityManager.isChecking()) {
            return SecurityActions.internalGetGlobalJaasConfiguration();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Configuration>(){

                @Override
                public Configuration run() throws Exception {
                    return SecurityActions.internalGetGlobalJaasConfiguration();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SecurityException)e.getCause();
        }
    }

    private static Configuration internalGetGlobalJaasConfiguration() throws SecurityException {
        return Configuration.getConfiguration();
    }

    static void setGlobalJaasConfiguration(final Configuration configuration) throws SecurityException {
        if (!WildFlySecurityManager.isChecking()) {
            SecurityActions.internalSetGlobalJaasConfiguration(configuration);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SecurityActions.internalSetGlobalJaasConfiguration(configuration);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SecurityException)e.getCause();
            }
        }
    }

    private static void internalSetGlobalJaasConfiguration(Configuration configuration) throws SecurityException {
        Configuration.setConfiguration(configuration);
    }
}

