/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.util.Objects;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.wildfly.common.Assert;

public abstract class EJBLocator<T>
implements Serializable {
    private static final long serialVersionUID = -7306257085240447972L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("viewType", Class.class), new ObjectStreamField("appName", String.class), new ObjectStreamField("moduleName", String.class), new ObjectStreamField("beanName", String.class), new ObjectStreamField("distinctName", String.class), new ObjectStreamField("affinity", Affinity.class), new ObjectStreamField("identifier", EJBIdentifier.class)};
    private final Class<T> viewType;
    private final EJBIdentifier identifier;
    private final Affinity affinity;
    private int hashCode;
    private EJBProxyInformation<T> proxyInformation;
    private static final Field viewTypeSetter;
    private static final Field identifierSetter;
    private static final Field affinitySetter;

    EJBLocator(Class<T> viewType, EJBIdentifier identifier, Affinity affinity) {
        Assert.checkNotNullParam((String)"viewType", viewType);
        Assert.checkNotNullParam((String)"identifier", (Object)identifier);
        Assert.checkNotNullParam((String)"affinity", (Object)affinity);
        this.viewType = viewType;
        this.identifier = identifier;
        this.affinity = affinity == null ? Affinity.NONE : affinity;
    }

    EJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, Affinity affinity) {
        this(viewType, new EJBIdentifier(appName, moduleName, beanName, distinctName), affinity);
    }

    EJBLocator(EJBLocator<T> original, Affinity newAffinity) {
        this(((EJBLocator)Assert.checkNotNullParam((String)"original", original)).viewType, original.identifier, newAffinity);
    }

    public abstract EJBLocator<T> withNewAffinity(Affinity var1);

    public StatefulEJBLocator<T> withSession(SessionID sessionId) {
        throw Logs.MAIN.cannotConvertToStateful(this);
    }

    public StatefulEJBLocator<T> withSessionAndAffinity(SessionID sessionId, Affinity affinity) {
        throw Logs.MAIN.cannotConvertToStateful(this);
    }

    public boolean canNarrowTo(Class<?> type) {
        return type != null && type.isAssignableFrom(this.viewType);
    }

    public <S> EJBLocator<? extends S> narrowTo(Class<S> type) {
        if (type.isAssignableFrom(this.viewType)) {
            return this;
        }
        throw new ClassCastException(type.toString());
    }

    public <S extends EJBHome> EJBHomeLocator<? extends S> narrowAsHome(Class<S> type) {
        throw new ClassCastException(EJBHomeLocator.class.toString());
    }

    public <S extends EJBObject> EntityEJBLocator<? extends S> narrowAsEntity(Class<S> type) {
        throw new ClassCastException(EntityEJBLocator.class.toString());
    }

    public <S> StatefulEJBLocator<? extends S> narrowAsStateful(Class<S> type) {
        throw new ClassCastException(StatefulEJBLocator.class.toString());
    }

    public <S> StatelessEJBLocator<? extends S> narrowAsStateless(Class<S> type) {
        throw new ClassCastException(StatelessEJBLocator.class.toString());
    }

    public StatelessEJBLocator<T> asStateless() {
        throw new ClassCastException(StatefulEJBLocator.class.toString());
    }

    public StatefulEJBLocator<T> asStateful() {
        throw new ClassCastException(StatefulEJBLocator.class.toString());
    }

    public boolean isStateless() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isHome() {
        return false;
    }

    public Class<T> getViewType() {
        return this.viewType;
    }

    public String getAppName() {
        return this.identifier.getAppName();
    }

    public String getModuleName() {
        return this.identifier.getModuleName();
    }

    public String getBeanName() {
        return this.identifier.getBeanName();
    }

    public String getDistinctName() {
        return this.identifier.getDistinctName();
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public EJBIdentifier getIdentifier() {
        return this.identifier;
    }

    public final int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode != 0) {
            return hashCode;
        }
        hashCode = this.calculateHashCode();
        this.hashCode = hashCode == 0 ? hashCode | Integer.MIN_VALUE : hashCode;
        return this.hashCode;
    }

    int calculateHashCode() {
        return Objects.hashCode(this.viewType) + 13 * (Objects.hashCode(this.identifier) + 13 * Objects.hashCode(this.affinity));
    }

    public boolean equals(Object other) {
        return other instanceof EJBLocator && this.equals((EJBLocator)other);
    }

    public Class<? extends T> getProxyClass() {
        return this.getProxyInformation().getProxyClass();
    }

    public Constructor<? extends T> getProxyConstructor() {
        return this.getProxyInformation().getProxyConstructor();
    }

    EJBProxyInformation<T> getProxyInformation() {
        EJBProxyInformation<T> i = this.proxyInformation;
        return i != null ? i : (this.proxyInformation = EJBProxyInformation.forViewType(this.viewType));
    }

    public T createProxyInstance(InvocationHandler invocationHandler) {
        Assert.checkNotNullParam((String)"invocationHandler", (Object)invocationHandler);
        try {
            return this.getProxyConstructor().newInstance(invocationHandler);
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e.getCause());
        }
    }

    public boolean equals(EJBLocator<?> other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.identifier.equals(other.identifier) && this.affinity.equals(other.affinity);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        try {
            Object identifierObj = fields.get("identifier", null);
            EJBIdentifier identifier = identifierObj != null ? (EJBIdentifier)identifierObj : new EJBIdentifier((String)fields.get("appName", null), (String)fields.get("moduleName", null), (String)fields.get("beanName", null), (String)fields.get("distinctName", null));
            viewTypeSetter.set(this, fields.get("viewType", null));
            identifierSetter.set(this, identifier);
            affinitySetter.set(this, fields.get("affinity", Affinity.NONE));
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        EJBIdentifier identifier = this.identifier;
        fields.put("identifier", identifier);
        fields.put("viewType", this.viewType);
        fields.put("affinity", this.affinity);
        fields.put("appName", identifier.getAppName());
        fields.put("moduleName", identifier.getModuleName());
        fields.put("beanName", identifier.getBeanName());
        fields.put("distinctName", identifier.getDistinctName());
        oos.writeFields();
    }

    public String toString() {
        return String.format("%s for \"%s\", view is %s, affinity is %s", this.getClass().getSimpleName(), this.identifier, this.getViewType(), this.getAffinity());
    }

    private static void secureSetAccessible(Field field, boolean flag) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(flag);
        } else {
            AccessController.doPrivileged(() -> {
                field.setAccessible(flag);
                return null;
            });
        }
    }

    static {
        Class<EJBLocator> clazz = EJBLocator.class;
        try {
            viewTypeSetter = clazz.getDeclaredField("viewType");
            EJBLocator.secureSetAccessible(viewTypeSetter, true);
            identifierSetter = clazz.getDeclaredField("identifier");
            EJBLocator.secureSetAccessible(identifierSetter, true);
            affinitySetter = clazz.getDeclaredField("affinity");
            EJBLocator.secureSetAccessible(affinitySetter, true);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
    }
}

