/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.cache.infinispan.entities.AbstractExtendableRevisioned;

public class CachedRealm
extends AbstractExtendableRevisioned {
    protected String name;
    protected String displayName;
    protected String displayNameHtml;
    protected boolean enabled;
    protected SslRequired sslRequired;
    protected boolean registrationAllowed;
    protected boolean registrationEmailAsUsername;
    protected boolean rememberMe;
    protected boolean verifyEmail;
    protected boolean loginWithEmailAllowed;
    protected boolean duplicateEmailsAllowed;
    protected boolean resetPasswordAllowed;
    protected boolean identityFederationEnabled;
    protected boolean editUsernameAllowed;
    protected boolean bruteForceProtected;
    protected boolean permanentLockout;
    protected int maxFailureWaitSeconds;
    protected int minimumQuickLoginWaitSeconds;
    protected int waitIncrementSeconds;
    protected long quickLoginCheckMilliSeconds;
    protected int maxDeltaTimeSeconds;
    protected int failureFactor;
    protected String defaultSignatureAlgorithm;
    protected boolean revokeRefreshToken;
    protected int refreshTokenMaxReuse;
    protected int ssoSessionIdleTimeout;
    protected int ssoSessionMaxLifespan;
    protected int offlineSessionIdleTimeout;
    protected boolean offlineSessionMaxLifespanEnabled;
    protected int offlineSessionMaxLifespan;
    protected int accessTokenLifespan;
    protected int accessTokenLifespanForImplicitFlow;
    protected int accessCodeLifespan;
    protected int accessCodeLifespanUserAction;
    protected int accessCodeLifespanLogin;
    protected int actionTokenGeneratedByAdminLifespan;
    protected int actionTokenGeneratedByUserLifespan;
    protected int notBefore;
    protected PasswordPolicy passwordPolicy;
    protected OTPPolicy otpPolicy;
    protected String loginTheme;
    protected String accountTheme;
    protected String adminTheme;
    protected String emailTheme;
    protected String masterAdminClient;
    protected List<RequiredCredentialModel> requiredCredentials;
    protected MultivaluedHashMap<String, ComponentModel> componentsByParent = new MultivaluedHashMap();
    protected MultivaluedHashMap<String, ComponentModel> componentsByParentAndType = new MultivaluedHashMap();
    protected Map<String, ComponentModel> components = new HashMap<String, ComponentModel>();
    protected List<IdentityProviderModel> identityProviders;
    protected Map<String, String> browserSecurityHeaders;
    protected Map<String, String> smtpConfig;
    protected Map<String, AuthenticationFlowModel> authenticationFlows = new HashMap<String, AuthenticationFlowModel>();
    protected List<AuthenticationFlowModel> authenticationFlowList;
    protected Map<String, AuthenticatorConfigModel> authenticatorConfigs = new HashMap<String, AuthenticatorConfigModel>();
    protected Map<String, RequiredActionProviderModel> requiredActionProviders = new HashMap<String, RequiredActionProviderModel>();
    protected List<RequiredActionProviderModel> requiredActionProviderList;
    protected Map<String, RequiredActionProviderModel> requiredActionProvidersByAlias = new HashMap<String, RequiredActionProviderModel>();
    protected MultivaluedHashMap<String, AuthenticationExecutionModel> authenticationExecutions = new MultivaluedHashMap();
    protected Map<String, AuthenticationExecutionModel> executionsById = new HashMap<String, AuthenticationExecutionModel>();
    protected AuthenticationFlowModel browserFlow;
    protected AuthenticationFlowModel registrationFlow;
    protected AuthenticationFlowModel directGrantFlow;
    protected AuthenticationFlowModel resetCredentialsFlow;
    protected AuthenticationFlowModel clientAuthenticationFlow;
    protected AuthenticationFlowModel dockerAuthenticationFlow;
    protected boolean eventsEnabled;
    protected long eventsExpiration;
    protected Set<String> eventsListeners;
    protected Set<String> enabledEventTypes;
    protected boolean adminEventsEnabled;
    protected Set<String> adminEnabledEventOperations = new HashSet<String>();
    protected boolean adminEventsDetailsEnabled;
    protected List<String> defaultRoles;
    private boolean allowUserManagedAccess;
    protected List<String> defaultGroups = new LinkedList<String>();
    protected List<String> clientScopes = new LinkedList<String>();
    protected List<String> defaultDefaultClientScopes = new LinkedList<String>();
    protected List<String> optionalDefaultClientScopes = new LinkedList<String>();
    protected boolean internationalizationEnabled;
    protected Set<String> supportedLocales;
    protected String defaultLocale;
    protected MultivaluedHashMap<String, IdentityProviderMapperModel> identityProviderMappers = new MultivaluedHashMap();
    protected Set<IdentityProviderMapperModel> identityProviderMapperSet;
    protected Map<String, String> attributes;
    private Map<String, Integer> userActionTokenLifespans;

    public Set<IdentityProviderMapperModel> getIdentityProviderMapperSet() {
        return this.identityProviderMapperSet;
    }

    public CachedRealm(Long revision, RealmModel model) {
        super(revision, model.getId());
        this.name = model.getName();
        this.displayName = model.getDisplayName();
        this.displayNameHtml = model.getDisplayNameHtml();
        this.enabled = model.isEnabled();
        this.allowUserManagedAccess = model.isUserManagedAccessAllowed();
        this.sslRequired = model.getSslRequired();
        this.registrationAllowed = model.isRegistrationAllowed();
        this.registrationEmailAsUsername = model.isRegistrationEmailAsUsername();
        this.rememberMe = model.isRememberMe();
        this.verifyEmail = model.isVerifyEmail();
        this.loginWithEmailAllowed = model.isLoginWithEmailAllowed();
        this.duplicateEmailsAllowed = model.isDuplicateEmailsAllowed();
        this.resetPasswordAllowed = model.isResetPasswordAllowed();
        this.identityFederationEnabled = model.isIdentityFederationEnabled();
        this.editUsernameAllowed = model.isEditUsernameAllowed();
        this.bruteForceProtected = model.isBruteForceProtected();
        this.permanentLockout = model.isPermanentLockout();
        this.maxFailureWaitSeconds = model.getMaxFailureWaitSeconds();
        this.minimumQuickLoginWaitSeconds = model.getMinimumQuickLoginWaitSeconds();
        this.waitIncrementSeconds = model.getWaitIncrementSeconds();
        this.quickLoginCheckMilliSeconds = model.getQuickLoginCheckMilliSeconds();
        this.maxDeltaTimeSeconds = model.getMaxDeltaTimeSeconds();
        this.failureFactor = model.getFailureFactor();
        this.defaultSignatureAlgorithm = model.getDefaultSignatureAlgorithm();
        this.revokeRefreshToken = model.isRevokeRefreshToken();
        this.refreshTokenMaxReuse = model.getRefreshTokenMaxReuse();
        this.ssoSessionIdleTimeout = model.getSsoSessionIdleTimeout();
        this.ssoSessionMaxLifespan = model.getSsoSessionMaxLifespan();
        this.offlineSessionIdleTimeout = model.getOfflineSessionIdleTimeout();
        this.offlineSessionMaxLifespanEnabled = model.isOfflineSessionMaxLifespanEnabled();
        this.offlineSessionMaxLifespan = model.getOfflineSessionMaxLifespan();
        this.accessTokenLifespan = model.getAccessTokenLifespan();
        this.accessTokenLifespanForImplicitFlow = model.getAccessTokenLifespanForImplicitFlow();
        this.accessCodeLifespan = model.getAccessCodeLifespan();
        this.accessCodeLifespanUserAction = model.getAccessCodeLifespanUserAction();
        this.accessCodeLifespanLogin = model.getAccessCodeLifespanLogin();
        this.actionTokenGeneratedByAdminLifespan = model.getActionTokenGeneratedByAdminLifespan();
        this.actionTokenGeneratedByUserLifespan = model.getActionTokenGeneratedByUserLifespan();
        this.notBefore = model.getNotBefore();
        this.passwordPolicy = model.getPasswordPolicy();
        this.otpPolicy = model.getOTPPolicy();
        this.loginTheme = model.getLoginTheme();
        this.accountTheme = model.getAccountTheme();
        this.adminTheme = model.getAdminTheme();
        this.emailTheme = model.getEmailTheme();
        this.requiredCredentials = model.getRequiredCredentials();
        this.userActionTokenLifespans = Collections.unmodifiableMap(new HashMap(model.getUserActionTokenLifespans()));
        this.identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderModel identityProviderModel : model.getIdentityProviders()) {
            this.identityProviders.add(new IdentityProviderModel(identityProviderModel));
        }
        this.identityProviders = Collections.unmodifiableList(this.identityProviders);
        this.identityProviderMapperSet = model.getIdentityProviderMappers();
        for (IdentityProviderMapperModel mapper : this.identityProviderMapperSet) {
            this.identityProviderMappers.add((Object)mapper.getIdentityProviderAlias(), (Object)mapper);
        }
        this.smtpConfig = model.getSmtpConfig();
        this.browserSecurityHeaders = model.getBrowserSecurityHeaders();
        this.eventsEnabled = model.isEventsEnabled();
        this.eventsExpiration = model.getEventsExpiration();
        this.eventsListeners = model.getEventsListeners();
        this.enabledEventTypes = model.getEnabledEventTypes();
        this.adminEventsEnabled = model.isAdminEventsEnabled();
        this.adminEventsDetailsEnabled = model.isAdminEventsDetailsEnabled();
        this.defaultRoles = model.getDefaultRoles();
        ClientModel masterAdminClient = model.getMasterAdminClient();
        this.masterAdminClient = masterAdminClient != null ? masterAdminClient.getId() : null;
        this.cacheClientScopes(model);
        this.internationalizationEnabled = model.isInternationalizationEnabled();
        this.supportedLocales = model.getSupportedLocales();
        this.defaultLocale = model.getDefaultLocale();
        this.authenticationFlowList = model.getAuthenticationFlows();
        for (AuthenticationFlowModel flow : this.authenticationFlowList) {
            this.authenticationFlows.put(flow.getId(), flow);
            this.authenticationExecutions.put((Object)flow.getId(), new LinkedList());
            for (AuthenticationExecutionModel execution : model.getAuthenticationExecutions(flow.getId())) {
                this.authenticationExecutions.add((Object)flow.getId(), (Object)execution);
                this.executionsById.put(execution.getId(), execution);
            }
        }
        for (AuthenticatorConfigModel authenticator : model.getAuthenticatorConfigs()) {
            this.authenticatorConfigs.put(authenticator.getId(), authenticator);
        }
        this.requiredActionProviderList = model.getRequiredActionProviders();
        for (RequiredActionProviderModel action : this.requiredActionProviderList) {
            this.requiredActionProviders.put(action.getId(), action);
            this.requiredActionProvidersByAlias.put(action.getAlias(), action);
        }
        for (GroupModel group : model.getDefaultGroups()) {
            this.defaultGroups.add(group.getId());
        }
        this.browserFlow = model.getBrowserFlow();
        this.registrationFlow = model.getRegistrationFlow();
        this.directGrantFlow = model.getDirectGrantFlow();
        this.resetCredentialsFlow = model.getResetCredentialsFlow();
        this.clientAuthenticationFlow = model.getClientAuthenticationFlow();
        this.dockerAuthenticationFlow = model.getDockerAuthenticationFlow();
        for (ComponentModel component : model.getComponents()) {
            this.componentsByParentAndType.add((Object)(component.getParentId() + component.getProviderType()), (Object)component);
        }
        for (ComponentModel component : model.getComponents()) {
            this.componentsByParent.add((Object)component.getParentId(), (Object)component);
        }
        for (ComponentModel component : model.getComponents()) {
            this.components.put(component.getId(), component);
        }
        try {
            this.attributes = model.getAttributes();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected void cacheClientScopes(RealmModel model) {
        for (ClientScopeModel clientScope : model.getClientScopes()) {
            this.clientScopes.add(clientScope.getId());
        }
        for (ClientScopeModel clientScope : model.getDefaultClientScopes(true)) {
            this.defaultDefaultClientScopes.add(clientScope.getId());
        }
        for (ClientScopeModel clientScope : model.getDefaultClientScopes(false)) {
            this.optionalDefaultClientScopes.add(clientScope.getId());
        }
    }

    public String getMasterAdminClient() {
        return this.masterAdminClient;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameHtml() {
        return this.displayNameHtml;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SslRequired getSslRequired() {
        return this.sslRequired;
    }

    public boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public boolean isBruteForceProtected() {
        return this.bruteForceProtected;
    }

    public boolean isPermanentLockout() {
        return this.permanentLockout;
    }

    public int getMaxFailureWaitSeconds() {
        return this.maxFailureWaitSeconds;
    }

    public int getWaitIncrementSeconds() {
        return this.waitIncrementSeconds;
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.minimumQuickLoginWaitSeconds;
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.quickLoginCheckMilliSeconds;
    }

    public int getMaxDeltaTimeSeconds() {
        return this.maxDeltaTimeSeconds;
    }

    public int getFailureFactor() {
        return this.failureFactor;
    }

    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public boolean isLoginWithEmailAllowed() {
        return this.loginWithEmailAllowed;
    }

    public boolean isDuplicateEmailsAllowed() {
        return this.duplicateEmailsAllowed;
    }

    public boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public boolean isEditUsernameAllowed() {
        return this.editUsernameAllowed;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.defaultSignatureAlgorithm;
    }

    public boolean isRevokeRefreshToken() {
        return this.revokeRefreshToken;
    }

    public int getRefreshTokenMaxReuse() {
        return this.refreshTokenMaxReuse;
    }

    public int getSsoSessionIdleTimeout() {
        return this.ssoSessionIdleTimeout;
    }

    public int getSsoSessionMaxLifespan() {
        return this.ssoSessionMaxLifespan;
    }

    public int getOfflineSessionIdleTimeout() {
        return this.offlineSessionIdleTimeout;
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        return this.offlineSessionMaxLifespanEnabled;
    }

    public int getOfflineSessionMaxLifespan() {
        return this.offlineSessionMaxLifespan;
    }

    public int getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.accessTokenLifespanForImplicitFlow;
    }

    public int getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public int getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public Map<String, Integer> getUserActionTokenLifespans() {
        return this.userActionTokenLifespans;
    }

    public int getAccessCodeLifespanLogin() {
        return this.accessCodeLifespanLogin;
    }

    public int getActionTokenGeneratedByAdminLifespan() {
        return this.actionTokenGeneratedByAdminLifespan;
    }

    public int getActionTokenGeneratedByUserLifespan() {
        return this.actionTokenGeneratedByUserLifespan;
    }

    public int getActionTokenGeneratedByUserLifespan(String actionTokenId) {
        if (actionTokenId == null || this.userActionTokenLifespans.get(actionTokenId) == null) {
            return this.getActionTokenGeneratedByUserLifespan();
        }
        return this.userActionTokenLifespans.get(actionTokenId);
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public boolean isIdentityFederationEnabled() {
        return this.identityFederationEnabled;
    }

    public Map<String, String> getSmtpConfig() {
        return this.smtpConfig;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.browserSecurityHeaders;
    }

    public String getLoginTheme() {
        return this.loginTheme;
    }

    public String getAccountTheme() {
        return this.accountTheme;
    }

    public String getAdminTheme() {
        return this.adminTheme;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public long getEventsExpiration() {
        return this.eventsExpiration;
    }

    public Set<String> getEventsListeners() {
        return this.eventsListeners;
    }

    public Set<String> getEnabledEventTypes() {
        return this.enabledEventTypes;
    }

    public boolean isAdminEventsEnabled() {
        return this.adminEventsEnabled;
    }

    public Set<String> getAdminEnabledEventOperations() {
        return this.adminEnabledEventOperations;
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.adminEventsDetailsEnabled;
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        return this.identityProviders;
    }

    public boolean isInternationalizationEnabled() {
        return this.internationalizationEnabled;
    }

    public Set<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public MultivaluedHashMap<String, IdentityProviderMapperModel> getIdentityProviderMappers() {
        return this.identityProviderMappers;
    }

    public Map<String, AuthenticationFlowModel> getAuthenticationFlows() {
        return this.authenticationFlows;
    }

    public Map<String, AuthenticatorConfigModel> getAuthenticatorConfigs() {
        return this.authenticatorConfigs;
    }

    public MultivaluedHashMap<String, AuthenticationExecutionModel> getAuthenticationExecutions() {
        return this.authenticationExecutions;
    }

    public Map<String, AuthenticationExecutionModel> getExecutionsById() {
        return this.executionsById;
    }

    public Map<String, RequiredActionProviderModel> getRequiredActionProviders() {
        return this.requiredActionProviders;
    }

    public Map<String, RequiredActionProviderModel> getRequiredActionProvidersByAlias() {
        return this.requiredActionProvidersByAlias;
    }

    public OTPPolicy getOtpPolicy() {
        return this.otpPolicy;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        return this.browserFlow;
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        return this.registrationFlow;
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        return this.directGrantFlow;
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        return this.resetCredentialsFlow;
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        return this.clientAuthenticationFlow;
    }

    public AuthenticationFlowModel getDockerAuthenticationFlow() {
        return this.dockerAuthenticationFlow;
    }

    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public List<String> getClientScopes() {
        return this.clientScopes;
    }

    public List<String> getDefaultDefaultClientScopes() {
        return this.defaultDefaultClientScopes;
    }

    public List<String> getOptionalDefaultClientScopes() {
        return this.optionalDefaultClientScopes;
    }

    public List<AuthenticationFlowModel> getAuthenticationFlowList() {
        return this.authenticationFlowList;
    }

    public List<RequiredActionProviderModel> getRequiredActionProviderList() {
        return this.requiredActionProviderList;
    }

    public MultivaluedHashMap<String, ComponentModel> getComponentsByParent() {
        return this.componentsByParent;
    }

    public MultivaluedHashMap<String, ComponentModel> getComponentsByParentAndType() {
        return this.componentsByParentAndType;
    }

    public Map<String, ComponentModel> getComponents() {
        return this.components;
    }

    public String getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Long.parseLong(v) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isAllowUserManagedAccess() {
        return this.allowUserManagedAccess;
    }
}

