/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class OfflinePersistentUserSessionLoaderContext
implements SessionLoader.LoaderContext,
Serializable {
    private final int sessionsTotal;
    private final int segmentsCount;
    private final int sessionsPerSegment;

    public OfflinePersistentUserSessionLoaderContext(int sessionsTotal, int sessionsPerSegment) {
        this.sessionsTotal = sessionsTotal;
        this.sessionsPerSegment = sessionsPerSegment;
        int segmentsCount = sessionsTotal / sessionsPerSegment;
        if (sessionsTotal % sessionsPerSegment >= 1) {
            ++segmentsCount;
        }
        this.segmentsCount = segmentsCount;
    }

    public int getSessionsTotal() {
        return this.sessionsTotal;
    }

    @Override
    public int getSegmentsCount() {
        return this.segmentsCount;
    }

    public int getSessionsPerSegment() {
        return this.sessionsPerSegment;
    }

    public String toString() {
        return "OfflinePersistentUserSessionLoaderContext [ " + " sessionsTotal: " + this.sessionsTotal + ", sessionsPerSegment: " + this.sessionsPerSegment + ", segmentsCount: " + this.segmentsCount + " ]";
    }
}

