/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.security;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.controller.resources.VaultResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.operations.SystemPropertyDeferredProcessor;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class VaultAddHandler
extends AbstractAddStepHandler {
    private final AbstractVaultReader vaultReader;

    public VaultAddHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : VaultResourceDefinition.ALL_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
        if (model.hasDefined(VaultResourceDefinition.MODULE.getName()) && !model.hasDefined(VaultResourceDefinition.CODE.getName())) {
            throw ServerLogger.ROOT_LOGGER.vaultModuleWithNoCode();
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String module;
        ModelNode codeNode = VaultResourceDefinition.CODE.resolveModelAttribute(context, model);
        ModelNode moduleNode = VaultResourceDefinition.MODULE.resolveModelAttribute(context, model);
        String vaultClass = codeNode.isDefined() ? codeNode.asString() : null;
        String string = module = moduleNode.isDefined() ? moduleNode.asString() : null;
        if (this.vaultReader != null) {
            HashMap<String, Object> vaultOptions = new HashMap<String, Object>();
            if (operation.hasDefined(VaultResourceDefinition.VAULT_OPTIONS.getName())) {
                for (Map.Entry vaultOption : VaultResourceDefinition.VAULT_OPTIONS.unwrap((ExpressionResolver)context, model).entrySet()) {
                    vaultOptions.put((String)vaultOption.getKey(), vaultOption.getValue());
                }
            }
            this.vaultReader.createVault(vaultClass, module, vaultOptions);
            SystemPropertyDeferredProcessor deferredResolver = (SystemPropertyDeferredProcessor)context.getAttachment(SystemPropertyDeferredProcessor.ATTACHMENT_KEY);
            if (deferredResolver != null) {
                deferredResolver.processDeferredProperties(context);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        if (this.vaultReader != null) {
            this.vaultReader.destroyVault();
        }
    }
}

