/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.microprofile;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.jboss.resteasy.cdi.microprofile.RestClientDelegateBean;

public class RestClientExtension
implements Extension {
    private static Set<Class<?>> proxyTypes = new LinkedHashSet();
    private static Set<Throwable> errors = new LinkedHashSet<Throwable>();

    public void registerClient(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> pat) {
        Class typeDef = pat.getAnnotatedType().getJavaClass();
        if (typeDef.isInterface()) {
            proxyTypes.add(typeDef);
            pat.veto();
        } else {
            errors.add(new IllegalArgumentException("Rest client needs to be interface: " + typeDef));
        }
    }

    public void createProxy(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Class<?> proxyType : proxyTypes) {
            afterBeanDiscovery.addBean((Bean)new RestClientDelegateBean(proxyType, beanManager));
        }
    }

    public void reportErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        for (Throwable error : errors) {
            afterDeploymentValidation.addDeploymentProblem(error);
        }
    }
}

