/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final ContentRepository contentRepository;

    public ServerGroupDeploymentRemoveHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] hash;
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{operationAddress.getLastElement()});
        ModelNode deployment = context.readResourceFromRoot(deploymentAddress, false).getModel();
        if (deployment.has("content")) {
            byte[] currentHash = null;
            if (deployment.get("content").has("hash")) {
                currentHash = deployment.get("content").get("hash").asBytes();
            } else {
                List nodes = deployment.get("content").asList();
                for (ModelNode node : nodes) {
                    if (!node.has("hash")) continue;
                    currentHash = node.get("hash").asBytes();
                }
            }
            hash = currentHash;
        } else {
            hash = null;
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction != OperationContext.ResultAction.ROLLBACK && ServerGroupDeploymentRemoveHandler.this.contentRepository != null && hash != null) {
                    PathAddress operationAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    ServerGroupDeploymentRemoveHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress((PathAddress)operationAddress, (byte[])hash));
                }
            }
        });
    }
}

