/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.ProtonJSession;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.EndpointImplQuery;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.LinkNode;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportSession;

public class SessionImpl
extends EndpointImpl
implements ProtonJSession {
    private final ConnectionImpl _connection;
    private Map<String, SenderImpl> _senders = new LinkedHashMap<String, SenderImpl>();
    private Map<String, ReceiverImpl> _receivers = new LinkedHashMap<String, ReceiverImpl>();
    private List<LinkImpl> _oldLinksToFree = new ArrayList<LinkImpl>();
    private TransportSession _transportSession;
    private int _incomingCapacity = 0x100000;
    private int _incomingBytes = 0;
    private int _outgoingBytes = 0;
    private int _incomingDeliveries = 0;
    private int _outgoingDeliveries = 0;
    private long _outgoingWindow = Integer.MAX_VALUE;
    private Map<Symbol, Object> _properties;
    private Map<Symbol, Object> _remoteProperties;
    private Symbol[] _offeredCapabilities;
    private Symbol[] _remoteOfferedCapabilities;
    private Symbol[] _desiredCapabilities;
    private Symbol[] _remoteDesiredCapabilities;
    private LinkNode<SessionImpl> _node;

    SessionImpl(ConnectionImpl connection) {
        this._connection = connection;
        this._connection.incref();
        this._node = this._connection.addSessionEndpoint(this);
        this._connection.put(Event.Type.SESSION_INIT, this);
    }

    @Override
    public SenderImpl sender(String name) {
        SenderImpl sender = this._senders.get(name);
        if (sender == null) {
            sender = new SenderImpl(this, name);
            this._senders.put(name, sender);
        } else if (sender.getLocalState() == EndpointState.CLOSED && sender.getRemoteState() == EndpointState.CLOSED) {
            this._oldLinksToFree.add(sender);
            sender = new SenderImpl(this, name);
            this._senders.put(name, sender);
        }
        return sender;
    }

    @Override
    public ReceiverImpl receiver(String name) {
        ReceiverImpl receiver = this._receivers.get(name);
        if (receiver == null) {
            receiver = new ReceiverImpl(this, name);
            this._receivers.put(name, receiver);
        } else if (receiver.getLocalState() == EndpointState.CLOSED && receiver.getRemoteState() == EndpointState.CLOSED) {
            this._oldLinksToFree.add(receiver);
            receiver = new ReceiverImpl(this, name);
            this._receivers.put(name, receiver);
        }
        return receiver;
    }

    @Override
    public Session next(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        EndpointImplQuery query = new EndpointImplQuery(local, remote);
        LinkNode<SessionImpl> sessionNode = this._node.next(query);
        return sessionNode == null ? null : sessionNode.getValue();
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._connection;
    }

    @Override
    public ConnectionImpl getConnection() {
        return this.getConnectionImpl();
    }

    @Override
    void postFinal() {
        this._connection.put(Event.Type.SESSION_FINAL, this);
        this._connection.decref();
    }

    @Override
    void doFree() {
        this._connection.freeSession(this);
        this._connection.removeSessionEndpoint(this._node);
        this._node = null;
        ArrayList<SenderImpl> senders = new ArrayList<SenderImpl>(this._senders.values());
        for (SenderImpl sender : senders) {
            sender.free();
        }
        this._senders.clear();
        ArrayList<ReceiverImpl> receivers = new ArrayList<ReceiverImpl>(this._receivers.values());
        for (ReceiverImpl receiver : receivers) {
            receiver.free();
        }
        this._receivers.clear();
        ArrayList<LinkImpl> links = new ArrayList<LinkImpl>(this._oldLinksToFree);
        for (LinkImpl link : links) {
            link.free();
        }
    }

    void modifyEndpoints() {
        for (SenderImpl snd : this._senders.values()) {
            snd.modifyEndpoints();
        }
        for (ReceiverImpl rcv : this._receivers.values()) {
            rcv.modifyEndpoints();
        }
        this.modified();
    }

    TransportSession getTransportSession() {
        return this._transportSession;
    }

    void setTransportSession(TransportSession transportSession) {
        this._transportSession = transportSession;
    }

    void setNode(LinkNode<SessionImpl> node) {
        this._node = node;
    }

    void freeSender(SenderImpl sender) {
        String name = sender.getName();
        SenderImpl existing = this._senders.get(name);
        if (sender.equals(existing)) {
            this._senders.remove(name);
        } else {
            this._oldLinksToFree.remove(sender);
        }
    }

    void freeReceiver(ReceiverImpl receiver) {
        String name = receiver.getName();
        ReceiverImpl existing = this._receivers.get(name);
        if (receiver.equals(existing)) {
            this._receivers.remove(name);
        } else {
            this._oldLinksToFree.remove(receiver);
        }
    }

    @Override
    public int getIncomingCapacity() {
        return this._incomingCapacity;
    }

    @Override
    public void setIncomingCapacity(int capacity) {
        this._incomingCapacity = capacity;
    }

    @Override
    public int getIncomingBytes() {
        return this._incomingBytes;
    }

    void incrementIncomingBytes(int delta) {
        this._incomingBytes += delta;
    }

    @Override
    public int getOutgoingBytes() {
        return this._outgoingBytes;
    }

    void incrementOutgoingBytes(int delta) {
        this._outgoingBytes += delta;
    }

    void incrementIncomingDeliveries(int delta) {
        this._incomingDeliveries += delta;
    }

    int getOutgoingDeliveries() {
        return this._outgoingDeliveries;
    }

    void incrementOutgoingDeliveries(int delta) {
        this._outgoingDeliveries += delta;
    }

    @Override
    void localOpen() {
        this.getConnectionImpl().put(Event.Type.SESSION_LOCAL_OPEN, this);
    }

    @Override
    void localClose() {
        this.getConnectionImpl().put(Event.Type.SESSION_LOCAL_CLOSE, this);
    }

    @Override
    public void setOutgoingWindow(long outgoingWindow) {
        if (outgoingWindow < 0L || outgoingWindow > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value '" + outgoingWindow + "' must be in the" + " range [0 - 2^32-1]");
        }
        this._outgoingWindow = outgoingWindow;
    }

    @Override
    public long getOutgoingWindow() {
        return this._outgoingWindow;
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        return this._properties;
    }

    @Override
    public void setProperties(Map<Symbol, Object> properties) {
        this._properties = properties;
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this._remoteProperties;
    }

    void setRemoteProperties(Map<Symbol, Object> remoteProperties) {
        this._remoteProperties = remoteProperties;
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        return this._desiredCapabilities;
    }

    @Override
    public void setDesiredCapabilities(Symbol[] desiredCapabilities) {
        this._desiredCapabilities = desiredCapabilities;
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        return this._remoteDesiredCapabilities;
    }

    void setRemoteDesiredCapabilities(Symbol[] remoteDesiredCapabilities) {
        this._remoteDesiredCapabilities = remoteDesiredCapabilities;
    }

    @Override
    public Symbol[] getOfferedCapabilities() {
        return this._offeredCapabilities;
    }

    @Override
    public void setOfferedCapabilities(Symbol[] offeredCapabilities) {
        this._offeredCapabilities = offeredCapabilities;
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        return this._remoteOfferedCapabilities;
    }

    void setRemoteOfferedCapabilities(Symbol[] remoteOfferedCapabilities) {
        this._remoteOfferedCapabilities = remoteOfferedCapabilities;
    }
}

