/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.StringUtil;
import io.smallrye.config.inject.ConfigExtension;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class ConfigProducer
implements Serializable {
    @Produces
    Config getConfig(InjectionPoint injectionPoint) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return ConfigProvider.getConfig((ClassLoader)tccl);
    }

    @Dependent
    @Produces
    @ConfigProperty
    String produceStringConfigProperty(InjectionPoint ip) {
        return this.getValue(ip, String.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    Long getLongValue(InjectionPoint ip) {
        return this.getValue(ip, Long.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    Integer getIntegerValue(InjectionPoint ip) {
        return this.getValue(ip, Integer.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    Float produceFloatConfigProperty(InjectionPoint ip) {
        return this.getValue(ip, Float.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    Double produceDoubleConfigProperty(InjectionPoint ip) {
        return this.getValue(ip, Double.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    Boolean produceBooleanConfigProperty(InjectionPoint ip) {
        return this.getValue(ip, Boolean.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    <T> Optional<T> produceOptionalConfigValue(InjectionPoint injectionPoint) {
        Class valueType;
        Type type = injectionPoint.getAnnotated().getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.unwrapType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        return Optional.ofNullable(this.getValue(injectionPoint, valueType));
    }

    @Dependent
    @Produces
    @ConfigProperty
    <T> Set<T> producesSetConfigPropery(InjectionPoint ip) {
        Class valueType;
        Type type = ip.getAnnotated().getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.unwrapType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        HashSet<String> s = new HashSet<String>();
        String stringValue = this.getValue(ip, String.class);
        String[] split = StringUtil.split(stringValue);
        Config config = this.getConfig(ip);
        for (int i = 0; i < split.length; ++i) {
            String item = ((SmallRyeConfig)config).convert(split[i], valueType);
            s.add(item);
        }
        return s;
    }

    @Dependent
    @Produces
    @ConfigProperty
    <T> List<T> producesListConfigPropery(InjectionPoint ip) {
        Class valueType;
        Type type = ip.getAnnotated().getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.unwrapType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        ArrayList<String> s = new ArrayList<String>();
        String stringValue = this.getValue(ip, String.class);
        String[] split = StringUtil.split(stringValue);
        Config config = this.getConfig(ip);
        for (int i = 0; i < split.length; ++i) {
            String item = ((SmallRyeConfig)config).convert(split[i], valueType);
            s.add(item);
        }
        return s;
    }

    private <T> Class<T> unwrapType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private <T> T getValue(InjectionPoint injectionPoint, Class<T> target) {
        Config config = this.getConfig(injectionPoint);
        String name = this.getName(injectionPoint);
        try {
            if (name == null) {
                return null;
            }
            Optional optionalValue = config.getOptionalValue(name, target);
            if (optionalValue.isPresent()) {
                return optionalValue.get();
            }
            String defaultValue = this.getDefaultValue(injectionPoint);
            if (defaultValue != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                return ((SmallRyeConfig)config).convert(defaultValue, target);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigExtension.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    private String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            return ((ConfigProperty)qualifier).defaultValue();
        }
        return null;
    }
}

