/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationCoordinatorRPCService;
import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationCoordinatorService;
import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationParticipantService;
import com.arjuna.webservices11.wsarjtx.sei.TerminationCoordinatorPortTypeImpl;
import com.arjuna.webservices11.wsarjtx.sei.TerminationCoordinatorRPCPortTypeImpl;
import com.arjuna.webservices11.wsarjtx.sei.TerminationParticipantPortTypeImpl;
import com.arjuna.webservices11.wsat.sei.CompletionCoordinatorPortTypeImpl;
import com.arjuna.webservices11.wsat.sei.CompletionCoordinatorRPCPortTypeImpl;
import com.arjuna.webservices11.wsat.sei.CompletionInitiatorPortTypeImpl;
import com.arjuna.webservices11.wsat.sei.CoordinatorPortTypeImpl;
import com.arjuna.webservices11.wsat.sei.ParticipantPortTypeImpl;
import com.arjuna.webservices11.wsba.sei.BusinessAgreementWithCoordinatorCompletionCoordinatorPortTypeImpl;
import com.arjuna.webservices11.wsba.sei.BusinessAgreementWithCoordinatorCompletionParticipantPortTypeImpl;
import com.arjuna.webservices11.wsba.sei.BusinessAgreementWithParticipantCompletionCoordinatorPortTypeImpl;
import com.arjuna.webservices11.wsba.sei.BusinessAgreementWithParticipantCompletionParticipantPortTypeImpl;
import com.arjuna.webservices11.wscoor.sei.ActivationPortTypeImpl;
import com.arjuna.webservices11.wscoor.sei.CoordinationFaultPortTypeImpl;
import com.arjuna.webservices11.wscoor.sei.RegistrationPortTypeImpl;
import com.arjuna.webservices11.wscoor.sei.RegistrationResponsePortTypeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.webservices.service.EndpointPublishService;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.as.xts.GracefulShutdownDeploymentProcessor;
import org.jboss.as.xts.GracefulShutdownRejectionRule;
import org.jboss.as.xts.TxBridgeInboundRecoveryService;
import org.jboss.as.xts.TxBridgeOutboundRecoveryService;
import org.jboss.as.xts.XTSDependenciesDeploymentProcessor;
import org.jboss.as.xts.XTSHandlerDeploymentProcessor;
import org.jboss.as.xts.XTSHandlersService;
import org.jboss.as.xts.XTSInterceptorDeploymentProcessor;
import org.jboss.as.xts.XTSManagerService;
import org.jboss.as.xts.XTSServices;
import org.jboss.as.xts.XTSSubsystemDefinition;
import org.jboss.as.xts.logging.XtsAsLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.jbossts.XTSService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.invocation.RejectionRule;
import org.jboss.wsf.spi.management.ServerConfig;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorRPCService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionInitiatorService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CoordinatorService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.ParticipantService;
import org.oasis_open.docs.ws_tx.wsba._2006._06.BusinessAgreementWithCoordinatorCompletionCoordinatorService;
import org.oasis_open.docs.ws_tx.wsba._2006._06.BusinessAgreementWithCoordinatorCompletionParticipantService;
import org.oasis_open.docs.ws_tx.wsba._2006._06.BusinessAgreementWithParticipantCompletionCoordinatorService;
import org.oasis_open.docs.ws_tx.wsba._2006._06.BusinessAgreementWithParticipantCompletionParticipantService;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.ActivationService;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationFaultService;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationResponseService;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationService;

class XTSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final XTSSubsystemAdd INSTANCE = new XTSSubsystemAdd();
    private static final String WSAT_ASYNC_REGISTRATION_PARAM_NAME = "wsat.async.registration";
    private static final String[] WAR_DEPLOYMENT_NAMES = new String[]{"ws-c11.war", "ws-t11-coordinator.war", "ws-t11-participant.war", "ws-t11-client.war"};
    private static final ContextInfo[] contextDefinitions = new ContextInfo[]{new ContextInfo("ws-t11-coordinator", new EndpointInfo[]{new EndpointInfo(CoordinatorPortTypeImpl.class.getName(), CoordinatorService.class.getSimpleName()), new EndpointInfo(CompletionCoordinatorPortTypeImpl.class.getName(), CompletionCoordinatorService.class.getSimpleName()), new EndpointInfo(CompletionCoordinatorRPCPortTypeImpl.class.getName(), CompletionCoordinatorRPCService.class.getSimpleName()), new EndpointInfo(BusinessAgreementWithCoordinatorCompletionCoordinatorPortTypeImpl.class.getName(), BusinessAgreementWithCoordinatorCompletionCoordinatorService.class.getSimpleName()), new EndpointInfo(BusinessAgreementWithParticipantCompletionCoordinatorPortTypeImpl.class.getName(), BusinessAgreementWithParticipantCompletionCoordinatorService.class.getSimpleName()), new EndpointInfo(TerminationCoordinatorPortTypeImpl.class.getName(), TerminationCoordinatorService.class.getSimpleName()), new EndpointInfo(TerminationCoordinatorRPCPortTypeImpl.class.getName(), TerminationCoordinatorRPCService.class.getSimpleName())}), new ContextInfo("ws-t11-participant", new EndpointInfo[]{new EndpointInfo(ParticipantPortTypeImpl.class.getName(), ParticipantService.class.getSimpleName()), new EndpointInfo(BusinessAgreementWithCoordinatorCompletionParticipantPortTypeImpl.class.getName(), BusinessAgreementWithCoordinatorCompletionParticipantService.class.getSimpleName()), new EndpointInfo(BusinessAgreementWithParticipantCompletionParticipantPortTypeImpl.class.getName(), BusinessAgreementWithParticipantCompletionParticipantService.class.getSimpleName())}), new ContextInfo("ws-t11-client", new EndpointInfo[]{new EndpointInfo(CompletionInitiatorPortTypeImpl.class.getName(), CompletionInitiatorService.class.getSimpleName()), new EndpointInfo(TerminationParticipantPortTypeImpl.class.getName(), TerminationParticipantService.class.getSimpleName())})};
    private static final String WS_C11_CONTEXT_DEFINITION_NAME = "ws-c11";
    static final EndpointInfo[] wsC11 = new EndpointInfo[]{new EndpointInfo(ActivationPortTypeImpl.class.getName(), ActivationService.class.getSimpleName()), new EndpointInfo(RegistrationPortTypeImpl.class.getName(), RegistrationService.class.getSimpleName())};
    static final EndpointInfo[] wsC11Async = new EndpointInfo[]{new EndpointInfo(RegistrationResponsePortTypeImpl.class.getName(), RegistrationResponseService.class.getSimpleName()), new EndpointInfo(CoordinationFaultPortTypeImpl.class.getName(), CoordinationFaultService.class.getSimpleName())};

    private XTSSubsystemAdd() {
    }

    static Iterable<ContextInfo> getContextDefinitions(OperationContext context, ModelNode model) throws IllegalArgumentException, OperationFailedException {
        ArrayList<ContextInfo> updatedContextDefinitions = new ArrayList<ContextInfo>(Arrays.asList(contextDefinitions));
        ArrayList<EndpointInfo> wsC11EndpointInfos = new ArrayList<EndpointInfo>(Arrays.asList(wsC11));
        if (XTSSubsystemDefinition.ASYNC_REGISTRATION.resolveModelAttribute(context, model).asBoolean() || Boolean.getBoolean(WSAT_ASYNC_REGISTRATION_PARAM_NAME)) {
            wsC11EndpointInfos.addAll(Arrays.asList(wsC11Async));
        }
        ContextInfo wsC11ContextInfo = new ContextInfo(WS_C11_CONTEXT_DEFINITION_NAME, wsC11EndpointInfos.toArray(new EndpointInfo[wsC11EndpointInfos.size()]));
        updatedContextDefinitions.add(wsC11ContextInfo);
        return updatedContextDefinitions;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        XTSSubsystemDefinition.HOST_NAME.validateAndSet(operation, model);
        XTSSubsystemDefinition.ENVIRONMENT_URL.validateAndSet(operation, model);
        XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.validateAndSet(operation, model);
        XTSSubsystemDefinition.ASYNC_REGISTRATION.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Pattern urlPattern;
        Matcher urlMatcher;
        String coordinatorURL;
        String hostName = XTSSubsystemDefinition.HOST_NAME.resolveModelAttribute(context, model).asString();
        ModelNode coordinatorURLAttribute = XTSSubsystemDefinition.ENVIRONMENT_URL.resolveModelAttribute(context, model);
        String string = coordinatorURL = coordinatorURLAttribute.isDefined() ? coordinatorURLAttribute.asString() : null;
        if (coordinatorURL != null && (urlMatcher = (urlPattern = Pattern.compile("^([a-zA-Z]+://)(.*):([^/]*)(/.*)$")).matcher(coordinatorURL)).matches()) {
            String address = NetworkUtils.formatPossibleIpv6Address((String)urlMatcher.group(2));
            coordinatorURL = String.format("%s%s:%s%s", urlMatcher.group(1), address, urlMatcher.group(3), urlMatcher.group(4));
        }
        if (coordinatorURL != null) {
            XtsAsLogger.ROOT_LOGGER.debugf("nodeIdentifier=%s%n", coordinatorURL);
        }
        boolean isDefaultContextPropagation = model.hasDefined("default-context-propagation") ? model.get("default-context-propagation").asBoolean() : false;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("xts", Phase.PARSE, 8281, (DeploymentUnitProcessor)new XTSInterceptorDeploymentProcessor());
                processorTarget.addDeploymentProcessor("xts", Phase.PARSE, 8279, (DeploymentUnitProcessor)new XTSHandlerDeploymentProcessor());
                processorTarget.addDeploymentProcessor("xts", Phase.DEPENDENCIES, 4368, (DeploymentUnitProcessor)new XTSDependenciesDeploymentProcessor());
                processorTarget.addDeploymentProcessor("xts", Phase.POST_MODULE, 3600, (DeploymentUnitProcessor)new GracefulShutdownDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget target = context.getServiceTarget();
        ClassLoader loader = XTSService.class.getClassLoader();
        ArrayList<ServiceController> controllers = new ArrayList<ServiceController>();
        HashMap<Class<RejectionRule>, GracefulShutdownRejectionRule> attachments = new HashMap<Class<RejectionRule>, GracefulShutdownRejectionRule>();
        attachments.put(RejectionRule.class, new GracefulShutdownRejectionRule());
        for (ContextInfo contextInfo : XTSSubsystemAdd.getContextDefinitions(context, model)) {
            String contextName = contextInfo.contextPath;
            HashMap<String, String> map = new HashMap<String, String>();
            for (EndpointInfo endpointInfo : contextInfo.endpointInfo) {
                map.put(endpointInfo.URLPattern, endpointInfo.SEIClassname);
            }
            ServiceBuilder endpointBuilder = EndpointPublishService.createServiceBuilder((ServiceTarget)target, (String)contextName, (ClassLoader)loader, (String)hostName, map, null, null, null, attachments);
            controllers.add(endpointBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
        XTSHandlersService.install(target, isDefaultContextPropagation);
        XTSManagerService xtsService = new XTSManagerService(coordinatorURL);
        ServiceBuilder xtsServiceBuilder = target.addService(XTSServices.JBOSS_XTS_MAIN, (Service)xtsService);
        xtsServiceBuilder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER);
        xtsServiceBuilder.addDependency(WSServices.CONFIG_SERVICE, ServerConfig.class, xtsService.getWSServerConfig());
        xtsServiceBuilder.addDependency(WSServices.XTS_CLIENT_INTEGRATION_SERVICE);
        for (ServiceController controller : controllers) {
            xtsServiceBuilder.addDependency(controller.getName());
        }
        xtsServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        TxBridgeInboundRecoveryService txBridgeInboundRecoveryService = new TxBridgeInboundRecoveryService();
        ServiceBuilder txBridgeInboundRecoveryServiceBuilder = target.addService(XTSServices.JBOSS_XTS_TXBRIDGE_INBOUND_RECOVERY, (Service)txBridgeInboundRecoveryService);
        txBridgeInboundRecoveryServiceBuilder.addDependency(XTSServices.JBOSS_XTS_MAIN);
        txBridgeInboundRecoveryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        TxBridgeOutboundRecoveryService txBridgeOutboundRecoveryService = new TxBridgeOutboundRecoveryService();
        ServiceBuilder txBridgeOutboundRecoveryServiceBuilder = target.addService(XTSServices.JBOSS_XTS_TXBRIDGE_OUTBOUND_RECOVERY, (Service)txBridgeOutboundRecoveryService);
        txBridgeOutboundRecoveryServiceBuilder.addDependency(XTSServices.JBOSS_XTS_MAIN);
        txBridgeOutboundRecoveryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static class ContextInfo {
        String contextPath;
        EndpointInfo[] endpointInfo;

        ContextInfo(String contextPath, EndpointInfo[] endpointInfo) {
            this.contextPath = contextPath;
            this.endpointInfo = endpointInfo;
        }
    }

    private static class EndpointInfo {
        String SEIClassname;
        String URLPattern;

        EndpointInfo(String seiClassname, String urlPattern) {
            this.SEIClassname = seiClassname;
            this.URLPattern = urlPattern;
        }
    }
}

