/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class CredentialSourceDependency
implements SupplierDependency<CredentialSource> {
    private final ExceptionSupplier<CredentialSource, Exception> supplier;
    private final Iterable<Dependency> dependencies;

    public CredentialSourceDependency(OperationContext context, Attribute attribute, ModelNode model) throws OperationFailedException {
        DependencyCollectingServiceBuilder builder = new DependencyCollectingServiceBuilder();
        this.supplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition)attribute.getDefinition()), (ModelNode)model, (ServiceBuilder)builder);
        this.dependencies = builder;
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        for (Dependency dependency : this.dependencies) {
            dependency.register(builder);
        }
        return builder;
    }

    public CredentialSource get() {
        try {
            return (CredentialSource)this.supplier.get();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static class DependencyCollectingServiceBuilder
    extends DelegatingServiceBuilder<Object>
    implements Iterable<Dependency> {
        private final List<Dependency> dependencies = new LinkedList<Dependency>();

        DependencyCollectingServiceBuilder() {
            super(null);
        }

        protected ServiceBuilder<Object> getDelegate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Dependency> iterator() {
            return this.dependencies.iterator();
        }

        @Deprecated
        public ServiceBuilder<Object> addDependency(ServiceName serviceName) {
            this.dependencies.add((Dependency)new ServiceDependency(serviceName));
            return this;
        }
    }
}

