/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.factory.jmx;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.activemq.artemis.cli.ConfigurationException;
import org.apache.activemq.artemis.cli.factory.jmx.JmxAclHandler;
import org.apache.activemq.artemis.core.config.JMXConnectorConfiguration;
import org.apache.activemq.artemis.core.server.management.JMXAccessControlList;
import org.apache.activemq.artemis.core.server.management.ManagementContext;
import org.apache.activemq.artemis.dto.AccessDTO;
import org.apache.activemq.artemis.dto.AuthorisationDTO;
import org.apache.activemq.artemis.dto.EntryDTO;
import org.apache.activemq.artemis.dto.JMXConnectorDTO;
import org.apache.activemq.artemis.dto.ManagementContextDTO;
import org.apache.activemq.artemis.dto.MatchDTO;
import org.apache.activemq.artemis.utils.FactoryFinder;

public class ManagementFactory {
    private static ManagementContextDTO createJmxAclConfiguration(URI configURI, String artemisHome, String artemisInstance, URI artemisURIInstance) throws Exception {
        if (configURI.getScheme() == null) {
            throw new ConfigurationException("Invalid configuration URI, no scheme specified: " + configURI);
        }
        JmxAclHandler factory = null;
        try {
            FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/activemq/artemis/broker/jmx/");
            factory = (JmxAclHandler)finder.newInstance(configURI.getScheme());
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
        }
        return factory.createJmxAcl(configURI, artemisHome, artemisInstance, artemisURIInstance);
    }

    public static ManagementContextDTO createJmxAclConfiguration(String configuration, String artemisHome, String artemisInstance, URI artemisURIInstance) throws Exception {
        return ManagementFactory.createJmxAclConfiguration(new URI(configuration), artemisHome, artemisInstance, artemisURIInstance);
    }

    public static ManagementContext create(ManagementContextDTO config) {
        ManagementContext context = new ManagementContext();
        if (config.getAuthorisation() != null) {
            AuthorisationDTO authorisation = config.getAuthorisation();
            JMXAccessControlList accessControlList = new JMXAccessControlList();
            List entries = authorisation.getWhiteList().getEntries();
            for (Object entry : entries) {
                accessControlList.addToWhiteList(((EntryDTO)entry).domain, ((EntryDTO)entry).key);
            }
            List accessList = authorisation.getDefaultAccess().getAccess();
            for (AccessDTO access : accessList) {
                String[] split = access.roles.split(",");
                accessControlList.addToDefaultAccess(access.method, split);
            }
            List matches = authorisation.getRoleAccess().getMatch();
            for (MatchDTO match : matches) {
                List accesses = match.getAccess();
                for (AccessDTO access : accesses) {
                    String[] split = access.roles.split(",");
                    accessControlList.addToRoleAccess(match.getDomain(), match.getKey(), access.method, split);
                }
            }
            context.setAccessControlList(accessControlList);
        }
        if (config.getJmxConnector() != null) {
            JMXConnectorDTO jmxConnector = config.getJmxConnector();
            JMXConnectorConfiguration jmxConnectorConfiguration = new JMXConnectorConfiguration();
            jmxConnectorConfiguration.setConnectorPort(jmxConnector.getConnectorPort());
            if (jmxConnector.getConnectorHost() != null) {
                jmxConnectorConfiguration.setConnectorHost(jmxConnector.getConnectorHost());
            }
            if (jmxConnector.getJmxRealm() != null) {
                jmxConnectorConfiguration.setJmxRealm(jmxConnector.getJmxRealm());
            }
            if (jmxConnector.getAuthenticatorType() != null) {
                jmxConnectorConfiguration.setAuthenticatorType(jmxConnector.getAuthenticatorType());
            }
            if (jmxConnector.getKeyStorePath() != null) {
                jmxConnectorConfiguration.setKeyStorePath(jmxConnector.getKeyStorePath());
            }
            if (jmxConnector.getKeyStoreProvider() != null) {
                jmxConnectorConfiguration.setKeyStoreProvider(jmxConnector.getKeyStoreProvider());
            }
            if (jmxConnector.getKeyStorePassword() != null) {
                jmxConnectorConfiguration.setKeyStorePassword(jmxConnector.getKeyStorePassword());
            }
            if (jmxConnector.getTrustStorePath() != null) {
                jmxConnectorConfiguration.setTrustStorePath(jmxConnector.getTrustStorePath());
            }
            if (jmxConnector.getTrustStoreProvider() != null) {
                jmxConnectorConfiguration.setTrustStoreProvider(jmxConnector.getTrustStoreProvider());
            }
            if (jmxConnector.getTrustStorePassword() != null) {
                jmxConnectorConfiguration.setTrustStorePassword(jmxConnector.getTrustStorePassword());
            }
            if (jmxConnector.getObjectName() != null) {
                jmxConnectorConfiguration.setObjectName(jmxConnector.getObjectName());
            }
            if (jmxConnector.isSecured() != null) {
                jmxConnectorConfiguration.setSecured(jmxConnector.isSecured());
            }
            context.setJmxConnectorConfiguration(jmxConnectorConfiguration);
        }
        return context;
    }
}

