/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ConnectorServiceFactory;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.spi.core.remoting.AcceptorFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private ExecutorService executorService;
    private ExecutorService ioExecutorService;
    private ScheduledExecutorService scheduledExecutorService;
    private List<BaseInterceptor> incomingInterceptors = Collections.synchronizedList(new ArrayList());
    private List<BaseInterceptor> outgoingInterceptors = Collections.synchronizedList(new ArrayList());
    private Map<String, Transformer> divertTransformers;
    private Map<String, Transformer> bridgeTransformers;
    private Map<String, AcceptorFactory> acceptorFactories;
    private Map<String, Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> connectorServices = new ConcurrentHashMap<String, Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>>();

    public ServiceRegistryImpl() {
        this.divertTransformers = new ConcurrentHashMap<String, Transformer>();
        this.bridgeTransformers = new ConcurrentHashMap<String, Transformer>();
        this.acceptorFactories = new ConcurrentHashMap<String, AcceptorFactory>();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void addConnectorService(ConnectorServiceFactory connectorServiceFactory, ConnectorServiceConfiguration configuration) {
        this.connectorServices.put(configuration.getConnectorName(), (Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>)new Pair((Object)connectorServiceFactory, (Object)configuration));
    }

    @Override
    public void removeConnectorService(ConnectorServiceConfiguration configuration) {
        this.connectorServices.remove(configuration.getConnectorName());
    }

    @Override
    public Collection<Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> getConnectorServices(List<ConnectorServiceConfiguration> configs) {
        if (configs != null) {
            for (ConnectorServiceConfiguration config : configs) {
                if (this.connectorServices.get(config.getConnectorName()) != null) continue;
                ConnectorServiceFactory factory = (ConnectorServiceFactory)this.loadClass(config.getFactoryClassName());
                this.addConnectorService(factory, config);
            }
        }
        return this.connectorServices.values();
    }

    @Override
    public ConnectorServiceFactory getConnectorService(ConnectorServiceConfiguration configuration) {
        return (ConnectorServiceFactory)this.loadClass(configuration.getFactoryClassName());
    }

    @Override
    public void addIncomingInterceptor(BaseInterceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
    }

    @Override
    public List<BaseInterceptor> getIncomingInterceptors(List<String> classNames) {
        ArrayList<BaseInterceptor> interceptors = new ArrayList<BaseInterceptor>(this.incomingInterceptors);
        this.instantiateInterceptors(classNames, interceptors);
        return interceptors;
    }

    @Override
    public void addOutgoingInterceptor(BaseInterceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
    }

    @Override
    public List<BaseInterceptor> getOutgoingInterceptors(List<String> classNames) {
        ArrayList<BaseInterceptor> interceptors = new ArrayList<BaseInterceptor>(this.outgoingInterceptors);
        this.instantiateInterceptors(classNames, interceptors);
        return interceptors;
    }

    @Override
    public void addDivertTransformer(String name, Transformer transformer) {
        this.divertTransformers.put(name, transformer);
    }

    @Override
    public Transformer getDivertTransformer(String name, TransformerConfiguration transformerConfiguration) {
        Transformer transformer = this.divertTransformers.get(name);
        if (transformer == null && transformerConfiguration != null && transformerConfiguration.getClassName() != null) {
            transformer = this.instantiateTransformer(transformerConfiguration);
            this.addDivertTransformer(name, transformer);
        }
        return transformer;
    }

    @Override
    public ExecutorService getIOExecutorService() {
        return this.ioExecutorService;
    }

    @Override
    public void setIOExecutorService(ExecutorService ioExecutorService) {
        this.ioExecutorService = ioExecutorService;
    }

    @Override
    public void addBridgeTransformer(String name, Transformer transformer) {
        this.bridgeTransformers.put(name, transformer);
    }

    @Override
    public Transformer getBridgeTransformer(String name, TransformerConfiguration transformerConfiguration) {
        Transformer transformer = this.bridgeTransformers.get(name);
        if (transformer == null && transformerConfiguration != null && transformerConfiguration.getClassName() != null) {
            transformer = this.instantiateTransformer(transformerConfiguration);
            this.addBridgeTransformer(name, transformer);
        }
        return transformer;
    }

    @Override
    public AcceptorFactory getAcceptorFactory(String name, String className) {
        AcceptorFactory factory = this.acceptorFactories.get(name);
        if (factory == null && className != null) {
            factory = (AcceptorFactory)this.loadClass(className);
            this.addAcceptorFactory(name, factory);
        }
        return factory;
    }

    @Override
    public void addAcceptorFactory(String name, AcceptorFactory acceptorFactory) {
        this.acceptorFactories.put(name, acceptorFactory);
    }

    public <T> T loadClass(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    private Transformer instantiateTransformer(TransformerConfiguration transformerConfiguration) {
        Transformer transformer = null;
        if (transformerConfiguration != null && transformerConfiguration.getClassName() != null) {
            try {
                transformer = (Transformer)this.loadClass(transformerConfiguration.getClassName());
                transformer.init(Collections.unmodifiableMap(transformerConfiguration.getProperties()));
            }
            catch (Exception e) {
                throw ActiveMQMessageBundle.BUNDLE.errorCreatingTransformerClass(e, transformerConfiguration.getClassName());
            }
        }
        return transformer;
    }

    private void instantiateInterceptors(List<String> classNames, List<BaseInterceptor> interceptors) {
        if (classNames != null) {
            for (String className : classNames) {
                BaseInterceptor interceptor = (BaseInterceptor)this.loadClass(className);
                interceptors.add(interceptor);
            }
        }
    }
}

