/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.security;

import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSName;
import org.jboss.as.connector._private.Capabilities;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ElytronSubjectFactory
implements SubjectFactory,
Capabilities {
    private static final RuntimeCapability<Void> AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.security.authentication-context", (boolean)true, AuthenticationContext.class).build();
    private static final AuthenticationContextConfigurationClient AUTH_CONFIG_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final AuthenticationContext authenticationContext;
    private URI targetURI;

    public ElytronSubjectFactory() {
        this(null, null);
    }

    public ElytronSubjectFactory(AuthenticationContext authenticationContext, URI targetURI) {
        this.authenticationContext = authenticationContext;
        this.targetURI = targetURI;
    }

    public Subject createSubject() {
        Subject subject = this.createSubject(this.getAuthenticationContext());
        if (ConnectorLogger.ROOT_LOGGER.isTraceEnabled()) {
            ConnectorLogger.ROOT_LOGGER.subject(subject, Integer.toHexString(System.identityHashCode(subject)));
        }
        return subject;
    }

    public Subject createSubject(String authenticationContextName) {
        AuthenticationContext context;
        if (authenticationContextName != null && !authenticationContextName.isEmpty()) {
            ServiceContainer container = this.currentServiceContainer();
            ServiceName authContextServiceName = AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{authenticationContextName});
            context = (AuthenticationContext)container.getRequiredService(authContextServiceName).getValue();
        } else {
            context = this.getAuthenticationContext();
        }
        Subject subject = this.createSubject(context);
        if (ConnectorLogger.ROOT_LOGGER.isTraceEnabled()) {
            ConnectorLogger.ROOT_LOGGER.subject(subject, Integer.toHexString(System.identityHashCode(subject)));
        }
        return subject;
    }

    private Subject createSubject(AuthenticationContext authenticationContext) {
        AuthenticationConfiguration configuration = AUTH_CONFIG_CLIENT.getAuthenticationConfiguration(this.targetURI, authenticationContext);
        CallbackHandler handler = AUTH_CONFIG_CLIENT.getCallbackHandler(configuration);
        NameCallback nameCallback = new NameCallback("Username: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        CredentialCallback credentialCallback = new CredentialCallback(GSSKerberosCredential.class);
        try {
            handler.handle(new Callback[]{nameCallback, passwordCallback, credentialCallback});
            Subject subject = new Subject();
            if (credentialCallback.getCredential() != null) {
                GSSKerberosCredential kerberosCredential = (GSSKerberosCredential)GSSKerberosCredential.class.cast(credentialCallback.getCredential());
                this.addPrivateCredential(subject, kerberosCredential.getKerberosTicket());
                this.addPrivateCredential(subject, kerberosCredential.getGssCredential());
                GSSName gssName = kerberosCredential.getGssCredential().getName();
                subject.getPrincipals().add(new KerberosPrincipal(gssName.toString()));
            }
            if (nameCallback.getName() != null) {
                subject.getPrincipals().add((Principal)new NamePrincipal(nameCallback.getName()));
            }
            if (passwordCallback.getPassword() != null) {
                this.addPrivateCredential(subject, new PasswordCredential(nameCallback.getName(), passwordCallback.getPassword()));
            }
            return subject;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    private ServiceContainer currentServiceContainer() {
        if (WildFlySecurityManager.isChecking()) {
            return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
        }
        return CurrentServiceContainer.getServiceContainer();
    }

    private void addPrivateCredential(Subject subject, Object credential) {
        if (!WildFlySecurityManager.isChecking()) {
            subject.getPrivateCredentials().add(credential);
        } else {
            AccessController.doPrivileged(() -> {
                subject.getPrivateCredentials().add(credential);
                return null;
            });
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ElytronSubjectFactory@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("]");
        return sb.toString();
    }

    private AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext == null ? AuthenticationContext.captureCurrent() : this.authenticationContext;
    }
}

