/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.singleton.AbstractDistributedSingletonService;
import org.wildfly.clustering.server.singleton.DeferredInjector;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.server.singleton.Lifecycle;
import org.wildfly.clustering.server.singleton.ServiceLifecycle;

public class DistributedSingletonService
extends AbstractDistributedSingletonService<Lifecycle> {
    public DistributedSingletonService(DistributedSingletonServiceContext context, Service service, List<Map.Entry<ServiceName[], DeferredInjector<?>>> injectors) {
        super(context, new PrimaryServiceLifecycleFactory(context.getServiceName(), service, injectors));
    }

    @Override
    public Lifecycle get() {
        return this;
    }

    private static class PrimaryServiceLifecycleFactory
    implements Function<ServiceTarget, Lifecycle> {
        private final ServiceName name;
        private final Service service;
        private final List<Map.Entry<ServiceName[], DeferredInjector<?>>> injectors;

        PrimaryServiceLifecycleFactory(ServiceName name, Service service, List<Map.Entry<ServiceName[], DeferredInjector<?>>> injectors) {
            this.name = name;
            this.service = service;
            this.injectors = injectors;
        }

        @Override
        public Lifecycle apply(ServiceTarget target) {
            ServiceBuilder builder = target.addService(this.name);
            for (Map.Entry<ServiceName[], DeferredInjector<?>> entry : this.injectors) {
                entry.getValue().setConsumer(builder.provides(entry.getKey()));
            }
            return new ServiceLifecycle(builder.setInstance(this.service).setInitialMode(ServiceController.Mode.NEVER).install());
        }
    }
}

