/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.audit.AccessAuditResourceDefinition;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelNode;

public class JmxAuditLogHandlerReferenceResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"handler");

    public JmxAuditLogHandlerReferenceResourceDefinition(ManagedAuditLogger auditLogger) {
        super(PATH_ELEMENT, JMXExtension.getResourceDescriptionResolver("audit-log.handler"), (OperationStepHandler)new AuditLogHandlerReferenceAddHandler(auditLogger), (OperationStepHandler)new AuditLogHandlerReferenceRemoveHandler(auditLogger));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
    }

    private static boolean isNotAdminOnlyServer(OperationContext context) {
        return context.getProcessType().isHostController() || context.getRunningMode() != RunningMode.ADMIN_ONLY;
    }

    private static class AuditLogHandlerReferenceRemoveHandler
    extends AbstractRemoveStepHandler {
        private final ManagedAuditLogger auditLogger;

        AuditLogHandlerReferenceRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return JmxAuditLogHandlerReferenceResourceDefinition.isNotAdminOnlyServer(context);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().removeHandlerReference(PathAddress.pathAddress((ModelNode)operation.require("address")));
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.KEEP) {
                                auditLogger.getUpdater().applyChanges();
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    private static class AuditLogHandlerReferenceAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;

        AuditLogHandlerReferenceAddHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            boolean found;
            PathAddress addr = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = addr.getLastElement().getValue();
            boolean bl = found = context.getProcessType().isServer() ? this.lookForHandlerForServer(context, name) : this.lookForHandlerForHc(context, name);
            if (!found) {
                throw JmxLogger.ROOT_LOGGER.noHandlerCalled(name);
            }
            resource.getModel().setEmptyObject();
        }

        protected boolean requiresRuntime(OperationContext context) {
            return JmxAuditLogHandlerReferenceResourceDefinition.isNotAdminOnlyServer(context);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().addHandlerReference(PathAddress.pathAddress((ModelNode)operation.require("address")));
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.KEEP) {
                                auditLogger.getUpdater().applyChanges();
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }

        private boolean lookForHandlerForServer(OperationContext context, String name) {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            return this.lookForHandler(PathAddress.EMPTY_ADDRESS, root, name);
        }

        private boolean lookForHandlerForHc(OperationContext context, String name) {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            for (Resource.ResourceEntry entry : root.getChildren("host")) {
                if (!entry.getModel().isDefined()) continue;
                return this.lookForHandler(PathAddress.pathAddress((String)"host", (String)entry.getName()), root, name);
            }
            return false;
        }

        private boolean lookForHandler(PathAddress rootAddress, Resource root, String name) {
            PathAddress addr = rootAddress.append(new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuditResourceDefinition.PATH_ELEMENT});
            PathAddress referenceAddress = addr.append("file-handler", name);
            if (this.lookForResource(root, referenceAddress)) {
                return true;
            }
            referenceAddress = addr.append("syslog-handler", name);
            return this.lookForResource(root, referenceAddress);
        }

        private boolean lookForResource(Resource root, PathAddress pathAddress) {
            Resource current = root;
            for (PathElement element : pathAddress) {
                if ((current = current.getChild(element)) != null) continue;
                return false;
            }
            return true;
        }
    }
}

