/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.HashableMarshalledValue;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValue;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueExternalizer;

public class HashableMarshalledValueExternalizer<T>
implements Externalizer<HashableMarshalledValue<T>> {
    private final Externalizer<SimpleMarshalledValue<T>> externalizer = new SimpleMarshalledValueExternalizer();

    public void writeObject(ObjectOutput output, HashableMarshalledValue<T> object) throws IOException {
        this.externalizer.writeObject(output, object);
        output.writeInt(object.hashCode());
    }

    public HashableMarshalledValue<T> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        SimpleMarshalledValue value = (SimpleMarshalledValue)this.externalizer.readObject(input);
        int hashCode = input.readInt();
        return new HashableMarshalledValue(value.getBytes(), hashCode);
    }

    public Class<HashableMarshalledValue<T>> getTargetClass() {
        return HashableMarshalledValue.class;
    }
}

