/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    SecurityActions() {
    }

    static void clearPropertyPrivileged(final String key) {
        if (System.getSecurityManager() == null) {
            System.clearProperty(key);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.clearProperty(key);
            }
        });
    }

    static String getPropertyPrivileged(String key) {
        return SecurityActions.getPropertyPrivileged(key, null);
    }

    static String getPropertyPrivileged(final String name, final String def) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name, def);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, def);
            }
        });
    }

    static String setPropertyPrivileged(final String name, final String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.setProperty(name, value);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(name, value);
            }
        });
    }
}

