/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.server.attributes.ProvidersListAttributeBuilder;
import org.keycloak.subsystem.server.extension.KeycloakExtension;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemAdd;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemRemoveHandler;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemWriteAttributeHandler;
import org.keycloak.subsystem.server.extension.MigrateJsonOperation;

public class KeycloakSubsystemDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition WEB_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("web-context", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("auth"))).setRestartAllServices()).build();
    static final StringListAttributeDefinition PROVIDERS = new ProvidersListAttributeBuilder().build();
    static final SimpleAttributeDefinition MASTER_REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("master-realm-name", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("master"))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SCHEDULED_TASK_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scheduled-task-interval", ModelType.LONG, true).setAllowExpression(true)).setDefaultValue(new ModelNode("900"))).setRestartAllServices()).build();
    static final List<AttributeDefinition> ALL_ATTRIBUTES = new ArrayList<AttributeDefinition>();
    private static final Map<String, AttributeDefinition> DEFINITION_LOOKUP;
    private static KeycloakSubsystemWriteAttributeHandler attrHandler;

    protected KeycloakSubsystemDefinition() {
        super(KeycloakExtension.PATH_SUBSYSTEM, (ResourceDescriptionResolver)KeycloakExtension.getResourceDescriptionResolver("subsystem"), (OperationStepHandler)KeycloakSubsystemAdd.INSTANCE, (OperationStepHandler)KeycloakSubsystemRemoveHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(MigrateJsonOperation.DEFINITION, (OperationStepHandler)new MigrateJsonOperation());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attrDef : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attrDef, null, (OperationStepHandler)attrHandler);
        }
    }

    public static AttributeDefinition lookup(String name) {
        return DEFINITION_LOOKUP.get(name);
    }

    static {
        ALL_ATTRIBUTES.add((AttributeDefinition)WEB_CONTEXT);
        ALL_ATTRIBUTES.add((AttributeDefinition)PROVIDERS);
        ALL_ATTRIBUTES.add((AttributeDefinition)MASTER_REALM_NAME);
        ALL_ATTRIBUTES.add((AttributeDefinition)SCHEDULED_TASK_INTERVAL);
        DEFINITION_LOOKUP = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : ALL_ATTRIBUTES) {
            DEFINITION_LOOKUP.put(def.getXmlName(), def);
        }
        attrHandler = new KeycloakSubsystemWriteAttributeHandler(ALL_ATTRIBUTES);
    }
}

