/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email;

import com.sun.mail.smtp.SMTPMessage;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.truststore.HostnameVerificationPolicy;
import org.keycloak.truststore.JSSETruststoreConfigurator;

public class DefaultEmailSenderProvider
implements EmailSenderProvider {
    private static final Logger logger = Logger.getLogger(DefaultEmailSenderProvider.class);
    private final KeycloakSession session;

    public DefaultEmailSenderProvider(KeycloakSession session) {
        this.session = session;
    }

    public void send(Map<String, String> config, UserModel user, String subject, String textBody, String htmlBody) throws EmailException {
        Transport transport = null;
        try {
            String address = this.retrieveEmailAddress(user);
            Properties props = new Properties();
            if (config.containsKey("host")) {
                props.setProperty("mail.smtp.host", config.get("host"));
            }
            boolean auth = "true".equals(config.get("auth"));
            boolean ssl = "true".equals(config.get("ssl"));
            boolean starttls = "true".equals(config.get("starttls"));
            if (config.containsKey("port") && config.get("port") != null) {
                props.setProperty("mail.smtp.port", config.get("port"));
            }
            if (auth) {
                props.setProperty("mail.smtp.auth", "true");
            }
            if (ssl) {
                props.setProperty("mail.smtp.ssl.enable", "true");
            }
            if (starttls) {
                props.setProperty("mail.smtp.starttls.enable", "true");
            }
            if (ssl || starttls) {
                this.setupTruststore(props);
            }
            props.setProperty("mail.smtp.timeout", "10000");
            props.setProperty("mail.smtp.connectiontimeout", "10000");
            String from = config.get("from");
            String fromDisplayName = config.get("fromDisplayName");
            String replyTo = config.get("replyTo");
            String replyToDisplayName = config.get("replyToDisplayName");
            String envelopeFrom = config.get("envelopeFrom");
            Session session = Session.getInstance((Properties)props);
            MimeMultipart multipart = new MimeMultipart("alternative");
            if (textBody != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(textBody, "UTF-8");
                multipart.addBodyPart((BodyPart)textPart);
            }
            if (htmlBody != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
                multipart.addBodyPart((BodyPart)htmlPart);
            }
            SMTPMessage msg = new SMTPMessage(session);
            msg.setFrom((Address)this.toInternetAddress(from, fromDisplayName));
            msg.setReplyTo(new Address[]{this.toInternetAddress(from, fromDisplayName)});
            if (replyTo != null && !replyTo.isEmpty()) {
                msg.setReplyTo(new Address[]{this.toInternetAddress(replyTo, replyToDisplayName)});
            }
            if (envelopeFrom != null && !envelopeFrom.isEmpty()) {
                msg.setEnvelopeFrom(envelopeFrom);
            }
            msg.setHeader("To", address);
            msg.setSubject(subject, "utf-8");
            msg.setContent((Multipart)multipart);
            msg.saveChanges();
            msg.setSentDate(new Date());
            transport = session.getTransport("smtp");
            if (auth) {
                transport.connect(config.get("user"), config.get("password"));
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, (Address[])new InternetAddress[]{new InternetAddress(address)});
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToSendEmail(e);
            throw new EmailException((Throwable)e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    logger.warn((Object)"Failed to close transport", (Throwable)e);
                }
            }
        }
    }

    protected InternetAddress toInternetAddress(String email, String displayName) throws UnsupportedEncodingException, AddressException, EmailException {
        if (email == null || "".equals(email.trim())) {
            throw new EmailException("Please provide a valid address", null);
        }
        if (displayName == null || "".equals(displayName.trim())) {
            return new InternetAddress(email);
        }
        return new InternetAddress(email, displayName, "utf-8");
    }

    protected String retrieveEmailAddress(UserModel user) {
        return user.getEmail();
    }

    private void setupTruststore(Properties props) throws NoSuchAlgorithmException, KeyManagementException {
        JSSETruststoreConfigurator configurator = new JSSETruststoreConfigurator(this.session);
        SSLSocketFactory factory = configurator.getSSLSocketFactory();
        if (factory != null) {
            props.put("mail.smtp.ssl.socketFactory", factory);
            if (configurator.getProvider().getPolicy() == HostnameVerificationPolicy.ANY) {
                props.setProperty("mail.smtp.ssl.trust", "*");
            }
        }
    }

    public void close() {
    }
}

