/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509CertificateType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaxWriterUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static void writeKeyInfo(XMLStreamWriter writer, KeyInfoType keyInfo) throws ProcessingException {
        if (keyInfo.getContent() == null || keyInfo.getContent().size() == 0) {
            throw logger.writerInvalidKeyInfoNullContentError();
        }
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"ds", (String)"KeyInfo", (String)"http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeNameSpace((XMLStreamWriter)writer, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
        Object content = keyInfo.getContent().get(0);
        if (content instanceof Element) {
            Element element = (Element)keyInfo.getContent().get(0);
            StaxUtil.writeDOMNode((XMLStreamWriter)writer, (Node)element);
        } else if (content instanceof X509DataType) {
            X509DataType type = (X509DataType)content;
            if (type.getDataObjects().size() == 0) {
                throw logger.writerNullValueError("X509Data");
            }
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"ds", (String)"X509Data", (String)"http://www.w3.org/2000/09/xmldsig#");
            Object obj = type.getDataObjects().get(0);
            if (obj instanceof Element) {
                Element element = (Element)obj;
                StaxUtil.writeDOMElement((XMLStreamWriter)writer, (Element)element);
            } else if (obj instanceof X509CertificateType) {
                X509CertificateType cert = (X509CertificateType)obj;
                StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"ds", (String)"X509Certificate", (String)"http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(cert.getEncodedCertificate()));
                StaxUtil.writeEndElement((XMLStreamWriter)writer);
            }
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        } else if (content instanceof KeyValueType) {
            KeyValueType keyvalueType = (KeyValueType)content;
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"ds", (String)"KeyValue", (String)"http://www.w3.org/2000/09/xmldsig#");
            if (keyvalueType instanceof DSAKeyValueType) {
                StaxWriterUtil.writeDSAKeyValueType(writer, (DSAKeyValueType)keyvalueType);
            }
            if (keyvalueType instanceof RSAKeyValueType) {
                StaxWriterUtil.writeRSAKeyValueType(writer, (RSAKeyValueType)keyvalueType);
            }
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        } else {
            throw new ProcessingException("PL00069: Parser: Type not supported:" + content);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
    }

    public static void writeRSAKeyValueType(XMLStreamWriter writer, RSAKeyValueType type) throws ProcessingException {
        String prefix = "ds";
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"RSAKeyValue", (String)"http://www.w3.org/2000/09/xmldsig#");
        byte[] modulus = type.getModulus();
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"Modulus", (String)"http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(modulus));
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
        byte[] exponent = type.getExponent();
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"Exponent", (String)"http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(exponent));
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
    }

    public static void writeDSAKeyValueType(XMLStreamWriter writer, DSAKeyValueType type) throws ProcessingException {
        byte[] pgen;
        byte[] seed;
        byte[] y;
        byte[] g;
        byte[] q;
        String prefix = "ds";
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"DSAKeyValue", (String)"http://www.w3.org/2000/09/xmldsig#");
        byte[] p = type.getP();
        if (p != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"P", (String)"http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(p));
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        }
        if ((q = type.getQ()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"Q", (String)"http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(q));
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        }
        if ((g = type.getG()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"G", (String)"http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(g));
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        }
        if ((y = type.getY()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"Y", (String)"http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(y));
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        }
        if ((seed = type.getSeed()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"Seed", (String)"http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(seed));
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        }
        if ((pgen = type.getPgenCounter()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"PgenCounter", (String)"http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(pgen));
            StaxUtil.writeEndElement((XMLStreamWriter)writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
    }
}

