/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Collection;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.ScaleDownAttributes;

public class LiveOnlyDefinition
extends PersistentResourceDefinition {
    private static final Collection<AttributeDefinition> ATTRIBUTES = ScaleDownAttributes.SCALE_DOWN_ATTRIBUTES;
    private static final AbstractAddStepHandler ADD = new ActiveMQReloadRequiredHandlers.AddStepHandler(ATTRIBUTES){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.execute(context, operation);
            context.addStep(ManagementHelper.checkNoOtherSibling("ha-policy"), OperationContext.Stage.MODEL);
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateModel(operation, model);
        }
    };
    private static final AbstractWriteAttributeHandler WRITE_ATTRIBUTE = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
    public static final LiveOnlyDefinition INSTANCE = new LiveOnlyDefinition();

    private LiveOnlyDefinition() {
        super(MessagingExtension.LIVE_ONLY_PATH, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ADD, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)WRITE_ATTRIBUTE);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static HAPolicyConfiguration buildConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ScaleDownConfiguration scaleDownConfiguration = ScaleDownAttributes.addScaleDownConfiguration(context, model);
        return new LiveOnlyPolicyConfiguration(scaleDownConfiguration);
    }
}

