/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.sessions.AbstractLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshEvent;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;

public class CrossDCLastSessionRefreshStore
extends AbstractLastSessionRefreshStore {
    protected static final Logger logger = Logger.getLogger(CrossDCLastSessionRefreshStore.class);
    private final String eventKey;

    protected CrossDCLastSessionRefreshStore(int maxIntervalBetweenMessagesSeconds, int maxCount, String eventKey) {
        super(maxIntervalBetweenMessagesSeconds, maxCount);
        this.eventKey = eventKey;
    }

    @Override
    protected void sendMessage(KeycloakSession kcSession, Map<String, SessionData> refreshesToSend) {
        LastSessionRefreshEvent event = new LastSessionRefreshEvent(refreshesToSend);
        if (logger.isDebugEnabled()) {
            logger.debugf("Sending lastSessionRefreshes for key '%s'. Refreshes: %s", (Object)this.eventKey, (Object)event.getLastSessionRefreshes().toString());
        }
        ClusterProvider cluster = (ClusterProvider)kcSession.getProvider(ClusterProvider.class);
        cluster.notify(this.eventKey, (ClusterEvent)event, true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }
}

