/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    LOGGING_1_0("urn:jboss:domain:logging:1.0"),
    LOGGING_1_1("urn:jboss:domain:logging:1.1"),
    LOGGING_1_2("urn:jboss:domain:logging:1.2"),
    LOGGING_1_3("urn:jboss:domain:logging:1.3"),
    LOGGING_1_4("urn:jboss:domain:logging:1.4"),
    LOGGING_1_5("urn:jboss:domain:logging:1.5"),
    LOGGING_2_0("urn:jboss:domain:logging:2.0"),
    LOGGING_3_0("urn:jboss:domain:logging:3.0"),
    LOGGING_4_0("urn:jboss:domain:logging:4.0"),
    LOGGING_5_0("urn:jboss:domain:logging:5.0"),
    LOGGING_6_0("urn:jboss:domain:logging:6.0");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;
    private static final List<Namespace> READABLE;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static List<Namespace> readable() {
        return READABLE;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = LOGGING_6_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        ArrayList<Namespace> readable = new ArrayList<Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
            readable.add(namespace);
        }
        MAP = map;
        READABLE = Collections.unmodifiableList(readable);
    }
}

