/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.IdentityCapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.UnaryServiceNameFactory;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.IdentityGroupServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class IdentityGroupRequirementServiceConfiguratorProvider
implements IdentityGroupServiceConfiguratorProvider {
    private final ClusteringRequirement requirement;
    private final Function<String, JndiName> jndiNameFactory;

    protected IdentityGroupRequirementServiceConfiguratorProvider(ClusteringRequirement requirement) {
        this(requirement, null);
    }

    protected IdentityGroupRequirementServiceConfiguratorProvider(ClusteringRequirement requirement, Function<String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Collection<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringRequirement> registry, String group, String targetGroup) {
        IdentityCapabilityServiceConfigurator configurator = new IdentityCapabilityServiceConfigurator(registry.getServiceName((Requirement)this.requirement), (UnaryServiceNameFactory)this.requirement, targetGroup);
        if (this.jndiNameFactory == null || "default".equals(targetGroup)) {
            return Collections.singleton(configurator);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(group).getAbsoluteName());
        BinderServiceConfigurator binderConfigurator = new BinderServiceConfigurator(binding, configurator.getServiceName());
        return Arrays.asList(configurator, binderConfigurator);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

