/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.BaseXAResource;
import io.agroal.narayana.ConnectableLocalXAResource;
import io.agroal.narayana.LocalXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;

public class NarayanaTransactionIntegration
implements TransactionIntegration {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final String jndiName;
    private final boolean connectable;
    private final UUID key = UUID.randomUUID();

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this(transactionManager, transactionSynchronizationRegistry, null, false);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, false);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.jndiName = jndiName;
        this.connectable = connectable;
    }

    public Connection getConnection() throws SQLException {
        if (this.transactionRunning()) {
            return (Connection)this.transactionSynchronizationRegistry.getResource((Object)this.key);
        }
        return null;
    }

    public void associate(Connection connection, XAResource xaResource) throws SQLException {
        try {
            if (this.transactionRunning()) {
                boolean newEnlistment = this.transactionSynchronizationRegistry.getResource((Object)this.key) == null;
                this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new InterposedSynchronization(connection));
                if (newEnlistment) {
                    this.transactionSynchronizationRegistry.putResource((Object)this.key, (Object)connection);
                    Object xaResourceToEnlist = xaResource != null ? new BaseXAResource((TransactionAware)connection, xaResource, this.jndiName) : (this.connectable ? new ConnectableLocalXAResource((TransactionAware)connection, this.jndiName) : new LocalXAResource((TransactionAware)connection, this.jndiName));
                    this.transactionManager.getTransaction().enlistResource((XAResource)xaResourceToEnlist);
                } else {
                    ((TransactionAware)connection).transactionStart();
                }
            } else {
                ((TransactionAware)connection).transactionCheckCallback(this::transactionRunning);
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception in association of connection to existing transaction", e);
        }
    }

    public boolean disassociate(Connection connection) throws SQLException {
        if (this.transactionRunning()) {
            this.transactionSynchronizationRegistry.putResource((Object)this.key, null);
        }
        return true;
    }

    private boolean transactionRunning() throws SQLException {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            return transaction != null && (transaction.getStatus() == 0 || transaction.getStatus() == 1);
        }
        catch (Exception e) {
            throw new SQLException("Exception in retrieving existing transaction", e);
        }
    }

    private static class InterposedSynchronization
    implements Synchronization {
        private final Connection connection;

        private InterposedSynchronization(Connection connection) {
            this.connection = connection;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

