/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.metadata.cache.AbstractBindingModel;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

public class QualifierModel<T extends Annotation>
extends AbstractBindingModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Collections.singleton(Qualifier.class);

    public QualifierModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        super(enhancedAnnotatedAnnotation);
    }

    @Override
    protected void initValid(EnhancedAnnotation<T> annotatedAnnotation) {
        super.initValid(annotatedAnnotation);
        for (EnhancedAnnotatedMethod<?, ?> annotatedMethod : annotatedAnnotation.getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getJavaClass()) && !Annotation.class.isAssignableFrom(annotatedMethod.getJavaClass()) || this.getNonBindingMembers().contains(annotatedMethod.slim())) continue;
            MetadataLogger.LOG.nonBindingMemberType(annotatedMethod);
            this.valid = false;
        }
    }

    @Override
    protected void check(EnhancedAnnotation<T> annotatedAnnotation) {
        super.check(annotatedAnnotation);
        if (this.isValid()) {
            if (!annotatedAnnotation.isAnnotationPresent(Target.class)) {
                ReflectionLogger.LOG.missingTarget(annotatedAnnotation);
            } else if (!Arrays2.unorderedEquals((Object[])((Target)annotatedAnnotation.getAnnotation(Target.class)).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})) {
                ReflectionLogger.LOG.missingTargetMethodFieldParameterType(annotatedAnnotation);
            }
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public boolean hasNonBindingMembers() {
        return this.getNonBindingMembers().size() > 0;
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        if (instance.annotationType().equals(this.getRawType()) && other.annotationType().equals(this.getRawType())) {
            for (AnnotatedMethod annotatedMethod : this.getAnnotatedAnnotation().getMethods()) {
                if (this.getNonBindingMembers().contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    AccessController.doPrivileged(SetAccessibleAction.of(annotatedMethod.getJavaMember()));
                    Object thisValue = annotatedMethod.getJavaMember().invoke((Object)instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.getJavaMember().invoke((Object)other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new WeldException(e);
                }
                catch (IllegalAccessException e) {
                    throw new WeldException(e);
                }
                catch (InvocationTargetException e) {
                    throw new WeldException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " qualifier model for " + this.getRawType() + " with non-binding members " + this.getNonBindingMembers();
    }
}

