/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.utils.RoleResolveUtil;

public class UserRealmRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "oidc-usermodel-realm-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Realm Role";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user realm role to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCtx) {
        String rolePrefix = (String)mappingModel.getConfig().get("usermodel.realmRoleMapping.rolePrefix");
        AccessToken.Access access = RoleResolveUtil.getResolvedRealmRoles(session, clientSessionCtx, false);
        if (access == null) {
            return;
        }
        AbstractUserRoleMappingMapper.setClaim(token, mappingModel, access.getRoles(), null, rolePrefix);
    }

    public static ProtocolMapperModel create(String realmRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken) {
        return UserRealmRoleMappingMapper.create(realmRolePrefix, name, tokenClaimName, accessToken, idToken, false);
    }

    public static ProtocolMapperModel create(String realmRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken, boolean multiValued) {
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper(name, "foo", tokenClaimName, "String", accessToken, idToken, false, PROVIDER_ID);
        mapper.getConfig().put("multivalued", String.valueOf(multiValued));
        mapper.getConfig().put("usermodel.realmRoleMapping.rolePrefix", realmRolePrefix);
        return mapper;
    }

    static {
        ProviderConfigProperty realmRolePrefix = new ProviderConfigProperty();
        realmRolePrefix.setName("usermodel.realmRoleMapping.rolePrefix");
        realmRolePrefix.setLabel("usermodel.realmRoleMapping.rolePrefix.label");
        realmRolePrefix.setHelpText("usermodel.realmRoleMapping.rolePrefix.tooltip");
        realmRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(realmRolePrefix);
        ProviderConfigProperty multiValued = new ProviderConfigProperty();
        multiValued.setName("multivalued");
        multiValued.setLabel("multivalued.label");
        multiValued.setHelpText("multivalued.tooltip");
        multiValued.setType("boolean");
        multiValued.setDefaultValue((Object)"true");
        CONFIG_PROPERTIES.add(multiValued);
        OIDCAttributeMapperHelper.addAttributeConfig(CONFIG_PROPERTIES, UserRealmRoleMappingMapper.class);
    }
}

