/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

public class SarLogger_$logger
extends DelegatingBasicLogger
implements SarLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SarLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String failedExecutingLegacyMethod = "WFLYSAR0001: Failed to execute legacy service %s method";
    private static final String propertyNotFound = "WFLYSAR0002: Unable to find PropertyEditor for type %s";
    private static final String classNotFound = "WFLYSAR0003: Class not found";
    private static final String classNotInstantiated = "WFLYSAR0004: Class not instantiated";
    private static final String failedToGetAttachment = "WFLYSAR0005: Failed to get %s attachment for %s";
    private static final String failedXmlParsing = "WFLYSAR0006: Failed to parse service xml [%s]";
    private static final String methodNotFound = "WFLYSAR0007: Method '%s(%s)' not found for: %s";
    private static final String missingRequiredAttributes = "WFLYSAR0008: Missing one or more required attributes:";
    private static final String nullVar = "WFLYSAR0009: %s is null";
    private static final String propertyMethodNotFound = "WFLYSAR0010: %s method for property '%s' not found for: %s";
    private static final String unexpectedContent = "WFLYSAR0011: Unexpected content of type '%s' named '%s', text is: %s";
    private static final String failedToProcessSarChild = "WFLYSAR0012: Failed to process SAR child archives for [%s]";
    private static final String malformedDependencyName = "WFLYSAR0013: Malformed dependency name %s";
    private static final String defaultConstructorNotFound = "WFLYSAR0014: Could not find default constructor for %s";

    public SarLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String failedExecutingLegacyMethod$str() {
        return failedExecutingLegacyMethod;
    }

    @Override
    public final String failedExecutingLegacyMethod(String methodName) {
        return String.format(this.getLoggingLocale(), this.failedExecutingLegacyMethod$str(), methodName);
    }

    @Override
    public final void propertyNotFound(Class<?> type) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.propertyNotFound$str(), type);
    }

    protected String propertyNotFound$str() {
        return propertyNotFound;
    }

    protected String classNotFound$str() {
        return classNotFound;
    }

    @Override
    public final IllegalArgumentException classNotFound(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classNotFound$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String classNotInstantiated$str() {
        return classNotInstantiated;
    }

    @Override
    public final IllegalArgumentException classNotInstantiated(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classNotInstantiated$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToGetAttachment$str() {
        return failedToGetAttachment;
    }

    @Override
    public final DeploymentUnitProcessingException failedToGetAttachment(String attachmentType, DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToGetAttachment$str(), attachmentType, deploymentUnit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedXmlParsing$str() {
        return failedXmlParsing;
    }

    @Override
    public final DeploymentUnitProcessingException failedXmlParsing(VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedXmlParsing$str(), xmlFile));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final DeploymentUnitProcessingException failedXmlParsing(Throwable cause, VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedXmlParsing$str(), xmlFile), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String methodNotFound$str() {
        return methodNotFound;
    }

    @Override
    public final IllegalStateException methodNotFound(String methodName, String methodParams, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodNotFound$str(), methodName, methodParams, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingRequiredAttributes$str() {
        return missingRequiredAttributes;
    }

    @Override
    public final String missingRequiredAttributes() {
        return String.format(this.getLoggingLocale(), this.missingRequiredAttributes$str(), new Object[0]);
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyMethodNotFound$str() {
        return propertyMethodNotFound;
    }

    @Override
    public final IllegalStateException propertyMethodNotFound(String methodPrefix, String propertyName, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.propertyMethodNotFound$str(), methodPrefix, propertyName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedContent$str() {
        return unexpectedContent;
    }

    @Override
    public final String unexpectedContent(String kind, QName name, String text) {
        return String.format(this.getLoggingLocale(), this.unexpectedContent$str(), kind, name, text);
    }

    protected String failedToProcessSarChild$str() {
        return failedToProcessSarChild;
    }

    @Override
    public final DeploymentUnitProcessingException failedToProcessSarChild(Throwable cause, VirtualFile deploymentRoot) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToProcessSarChild$str(), deploymentRoot), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String malformedDependencyName$str() {
        return malformedDependencyName;
    }

    @Override
    public final DeploymentUnitProcessingException malformedDependencyName(Throwable cause, String dependencyName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.malformedDependencyName$str(), dependencyName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String defaultConstructorNotFound$str() {
        return defaultConstructorNotFound;
    }

    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFound(Class<?> clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.defaultConstructorNotFound$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

