/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public final class MaskedPasswordSpec
implements PasswordSpec {
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] maskedPasswordBytes;

    public MaskedPasswordSpec(char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] maskedPasswordBytes) {
        Assert.checkNotNullParam("initialKeyMaterial", initialKeyMaterial);
        Assert.checkNotNullParam("salt", salt);
        Assert.checkNotNullParam("maskedPasswordBytes", maskedPasswordBytes);
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.maskedPasswordBytes = maskedPasswordBytes;
    }

    public char[] getInitialKeyMaterial() {
        return this.initialKeyMaterial;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getMaskedPasswordBytes() {
        return this.maskedPasswordBytes;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MaskedPasswordSpec)) {
            return false;
        }
        MaskedPasswordSpec o = (MaskedPasswordSpec)other;
        return Arrays.equals(this.initialKeyMaterial, o.initialKeyMaterial) && this.iterationCount == o.iterationCount && this.salt == o.salt && this.maskedPasswordBytes == o.maskedPasswordBytes;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.initialKeyMaterial), this.iterationCount), Arrays.hashCode(this.salt)), Arrays.hashCode(this.maskedPasswordBytes));
    }
}

