/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;

@DefaultFactoryFor(classes={KeyPartitioner.class})
public class KeyPartitionerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Inject
    private GroupManager groupManager;

    @Override
    public <T> T construct(Class<T> componentType) {
        if (this.configuration.clustering().cacheMode().needsStateTransfer()) {
            KeyPartitioner partitioner = this.configuration.clustering().hash().keyPartitioner();
            partitioner.init(this.configuration.clustering().hash());
            if (this.groupManager == null) {
                return componentType.cast(partitioner);
            }
            this.componentRegistry.wireDependencies(partitioner);
            GroupingPartitioner groupingPartitioner = new GroupingPartitioner(partitioner, this.groupManager);
            return componentType.cast(groupingPartitioner);
        }
        return componentType.cast(SingleSegmentKeyPartitioner.getInstance());
    }
}

