/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import io.reactivex.Flowable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.infinispan.commons.util.ByRef;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.async.AsyncCacheLoader;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.modifications.Modification;
import org.infinispan.persistence.modifications.Store;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class AdvancedAsyncCacheLoader<K, V>
extends AsyncCacheLoader<K, V>
implements AdvancedCacheLoader<K, V> {
    private static final Log log = LogFactory.getLog(AdvancedAsyncCacheLoader.class);

    public AdvancedAsyncCacheLoader(CacheLoader actual, AtomicReference<State> state) {
        super(actual, state);
    }

    @Override
    public Publisher<K> publishKeys(Predicate<? super K> filter) {
        ByRef hadClear;
        State state = (State)this.state.get();
        Map<Object, Modification> modificationMap = state.flattenModifications((ByRef<Boolean>)(hadClear = new ByRef((Object)Boolean.FALSE)));
        if (modificationMap.isEmpty()) {
            return this.advancedLoader().publishKeys(filter);
        }
        Flowable modPublisher = Flowable.fromIterable(modificationMap.entrySet()).filter(me -> Modification.Type.STORE == ((Modification)me.getValue()).getType()).map(e -> e.getKey());
        if (hadClear.get() == Boolean.TRUE) {
            return modPublisher;
        }
        filter = filter == null ? k -> !modificationMap.containsKey(k) : filter.and(k -> !modificationMap.containsKey(k));
        return Flowable.merge((Publisher)modPublisher, this.advancedLoader().publishKeys(filter));
    }

    @Override
    public Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        ByRef hadClear;
        State state = (State)this.state.get();
        Map<Object, Modification> modificationMap = state.flattenModifications((ByRef<Boolean>)(hadClear = new ByRef((Object)Boolean.FALSE)));
        if (modificationMap.isEmpty()) {
            return this.advancedLoader().publishEntries(filter, fetchValue, fetchMetadata);
        }
        Flowable modPublisher = Flowable.fromIterable(modificationMap.entrySet()).map(Map.Entry::getValue).filter(e -> Modification.Type.STORE == e.getType()).cast(Store.class).map(Store::getStoredValue);
        if (hadClear.get() == Boolean.TRUE) {
            return modPublisher;
        }
        filter = filter == null ? k -> !modificationMap.containsKey(k) : filter.and(k -> !modificationMap.containsKey(k));
        return Flowable.merge((Publisher)modPublisher, this.advancedLoader().publishEntries(filter, fetchValue, fetchMetadata));
    }

    @Override
    public int size() {
        return this.advancedLoader().size();
    }

    AdvancedCacheLoader<K, V> advancedLoader() {
        return (AdvancedCacheLoader)this.actual;
    }
}

