/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.DisplayTypeRequiredActionFactory;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.ConsoleUpdateTotp;
import org.keycloak.credential.CredentialInput;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.services.validation.Validation;

public class UpdateTotp
implements RequiredActionProvider,
RequiredActionFactory,
DisplayTypeRequiredActionFactory {
    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("mode", context.getUriInfo().getQueryParameters().getFirst((Object)"mode")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_TOTP);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        String mode = (String)formData.getFirst((Object)"mode");
        if (Validation.isBlank(totp)) {
            Response challenge = context.form().setAttribute("mode", (Object)mode).setError("missingTotpMessage", new Object[0]).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        if (!CredentialValidation.validOTP((RealmModel)context.getRealm(), (String)totp, (String)totpSecret)) {
            Response challenge = context.form().setAttribute("mode", (Object)mode).setError("invalidTotpMessage", new Object[0]).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType(context.getRealm().getOTPPolicy().getType());
        credentials.setValue(totpSecret);
        context.getSession().userCredentialManager().updateCredential(context.getRealm(), context.getUser(), (CredentialInput)credentials);
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType(context.getRealm().getOTPPolicy().getType());
        cred.setValue(totp);
        context.getSession().userCredentialManager().isValid(context.getRealm(), context.getUser(), new CredentialInput[]{cred});
        context.success();
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public RequiredActionProvider createDisplay(KeycloakSession session, String displayType) {
        if (displayType == null) {
            return this;
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return ConsoleUpdateTotp.SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Configure OTP";
    }

    public String getId() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }

    public boolean isOneTimeAction() {
        return true;
    }
}

