/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.ConcurrentRolloutPlanGroup;
import org.jboss.as.cli.operation.impl.RolloutPlanGroup;
import org.jboss.as.cli.operation.impl.SingleRolloutPlanGroup;
import org.jboss.dmr.ModelNode;

public class ParsedRolloutPlanHeader
implements ParsedOperationRequestHeader {
    private static final String HEADER_NAME = "rollout";
    private static final int SEPARATOR_GROUP_SEQUENCE = 1;
    private static final int SEPARATOR_GROUP_CONCURRENT = 2;
    private static final int SEPARATOR_PROPERTY = 3;
    private static final int SEPARATOR_PROPERTY_LIST_START = 4;
    private static final int SEPARATOR_PROPERTY_LIST_END = 5;
    private static final int SEPARATOR_PLAN_ID_VALUE = 6;
    private final String planId;
    private String planRef;
    private List<RolloutPlanGroup> groups;
    private Map<String, String> props;
    private SingleRolloutPlanGroup lastGroup;
    private String lastPropertyName;
    private String lastPropertyValue;
    private int lastChunkIndex;
    private int separator = -1;
    private int lastSeparatorIndex = -1;
    private Set<String> mentionedGroups;

    public ParsedRolloutPlanHeader() {
        this(null);
    }

    public ParsedRolloutPlanHeader(String planId) {
        this.planId = planId;
    }

    @Override
    public String getName() {
        return HEADER_NAME;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getPlanRef() {
        return this.planRef;
    }

    public void setPlanRef(int index, String planRef) {
        if (planRef == null || planRef.isEmpty()) {
            throw new IllegalArgumentException("Plan ref is null or empty.");
        }
        if (this.groups != null) {
            throw new IllegalStateException("Plan ref can't be specified when groups are specified.");
        }
        this.planRef = planRef;
        this.lastChunkIndex = index;
        this.separator = -1;
    }

    public boolean endsOnPlanIdValueSeparator() {
        return this.separator == 6;
    }

    public void planIdValueSeparator(int index) {
        this.lastSeparatorIndex = index;
        this.separator = 6;
    }

    public void addGroup(SingleRolloutPlanGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        if (this.planRef != null) {
            throw new IllegalStateException("Groups can't be added if the plan ref is specified.");
        }
        if (this.groups == null) {
            this.groups = new ArrayList<RolloutPlanGroup>();
        }
        this.groups.add(group);
        this.lastGroup = group;
        this.separator = -1;
        if (this.mentionedGroups == null) {
            this.mentionedGroups = new HashSet<String>();
        }
        this.mentionedGroups.add(group.getGroupName());
    }

    public void addConcurrentGroup(SingleRolloutPlanGroup group) {
        int lastIndex;
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        if (this.planRef != null) {
            throw new IllegalStateException("Groups can't be added if the plan ref is specified.");
        }
        int n = lastIndex = this.groups == null ? -1 : this.groups.size() - 1;
        if (lastIndex < 0) {
            throw new IllegalStateException("There must be a group before a concurrent group can be added.");
        }
        RolloutPlanGroup lastGroup = this.groups.get(lastIndex);
        if (lastGroup instanceof ConcurrentRolloutPlanGroup) {
            ((ConcurrentRolloutPlanGroup)lastGroup).addGroup(group);
        } else {
            ConcurrentRolloutPlanGroup concurrent = new ConcurrentRolloutPlanGroup();
            concurrent.addGroup(lastGroup);
            concurrent.addGroup(group);
            this.groups.set(lastIndex, concurrent);
        }
        this.lastGroup = group;
        this.separator = -1;
        if (this.mentionedGroups == null) {
            this.mentionedGroups = new HashSet<String>();
        }
        this.mentionedGroups.add(group.getGroupName());
    }

    public boolean containsGroup(String name) {
        return this.mentionedGroups == null ? false : this.mentionedGroups.contains(name);
    }

    public void addProperty(String name, String value, int valueIndex) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid property value: " + value);
        }
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name, value);
        this.lastGroup = null;
        this.separator = -1;
        this.lastPropertyName = name;
        this.lastPropertyValue = value;
        this.lastChunkIndex = valueIndex;
    }

    public void addProperty(String name, int index) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name, "true");
        this.lastGroup = null;
        this.separator = -1;
        this.lastPropertyName = name;
        this.lastChunkIndex = index;
    }

    public String getProperty(String name) {
        return this.props == null ? null : this.props.get(name);
    }

    public boolean hasProperties() {
        return this.props != null;
    }

    public void groupSequenceSeparator(int index) {
        this.separator = 1;
        this.lastSeparatorIndex = index;
    }

    public void groupConcurrentSeparator(int index) {
        this.separator = 2;
        this.lastSeparatorIndex = index;
    }

    public void propertySeparator(int index) {
        this.separator = 3;
        this.lastSeparatorIndex = index;
    }

    public boolean endsOnGroupSeparator() {
        return this.separator == 1 || this.separator == 2;
    }

    public boolean endsOnPropertySeparator() {
        return this.separator == 3;
    }

    public boolean endsOnPropertyListStart() {
        return this.separator == 4;
    }

    public boolean endsOnPropertyListEnd() {
        return this.separator == 5;
    }

    public int getLastSeparatorIndex() {
        return this.lastSeparatorIndex;
    }

    public int getLastChunkIndex() {
        return this.lastChunkIndex;
    }

    public String getLastPropertyName() {
        return this.lastPropertyName;
    }

    public String getLastPropertyValue() {
        return this.lastPropertyValue;
    }

    public void propertyListStart(int index) {
        this.lastSeparatorIndex = index;
        this.separator = 4;
    }

    public void propertyListEnd(int index) {
        this.lastSeparatorIndex = index;
        this.separator = 5;
        this.lastPropertyName = null;
        this.lastPropertyValue = null;
    }

    @Override
    public void addTo(CommandContext ctx, ModelNode headers) throws CommandFormatException {
        if (this.planRef != null) {
            ModelNode rolloutPlan = Util.getRolloutPlan(ctx.getModelControllerClient(), this.planRef);
            headers.set(rolloutPlan);
            return;
        }
        ModelNode header = headers.get("rollout-plan");
        ModelNode series = header.get("in-series");
        for (RolloutPlanGroup group : this.groups) {
            group.addTo(series);
        }
        if (this.props != null) {
            for (String propName : this.props.keySet()) {
                header.get(propName).set(this.props.get(propName));
            }
        }
    }

    public SingleRolloutPlanGroup getLastGroup() {
        return this.lastGroup;
    }
}

