/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public final class InVMNodeManager
extends NodeManager {
    private final Semaphore liveLock;
    private final Semaphore backupLock;
    public State state = State.NOT_STARTED;
    public long failoverPause = 0L;

    public InVMNodeManager(boolean replicatedBackup) {
        this(replicatedBackup, null);
        if (replicatedBackup) {
            throw new RuntimeException("if replicated-backup, we need its journal directory");
        }
    }

    public InVMNodeManager(boolean replicatedBackup, File directory) {
        super(replicatedBackup, directory);
        this.liveLock = new Semaphore(1);
        this.backupLock = new Semaphore(1);
        this.setUUID(UUIDGenerator.getInstance().generateUUID());
    }

    @Override
    public void awaitLiveNode() throws Exception {
        while (true) {
            if (this.state == State.NOT_STARTED) {
                Thread.sleep(2000L);
                continue;
            }
            this.liveLock.acquire();
            if (this.state == State.PAUSED) {
                this.liveLock.release();
                Thread.sleep(2000L);
                continue;
            }
            if (this.state == State.FAILING_BACK) {
                this.liveLock.release();
                Thread.sleep(2000L);
                continue;
            }
            if (this.state == State.LIVE) break;
        }
        if (this.failoverPause > 0L) {
            Thread.sleep(this.failoverPause);
        }
    }

    @Override
    public void awaitLiveStatus() throws Exception {
        while (this.state != State.LIVE) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void startBackup() throws Exception {
        this.backupLock.acquire();
    }

    @Override
    public ActivateCallback startLiveNode() throws Exception {
        this.state = State.FAILING_BACK;
        this.liveLock.acquire();
        return new ActivateCallback(){

            @Override
            public void activationComplete() {
                try {
                    InVMNodeManager.this.state = State.LIVE;
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.state = State.PAUSED;
        this.liveLock.release();
    }

    @Override
    public void crashLiveServer() throws Exception {
        this.liveLock.release();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.state == State.FAILING_BACK;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        return this.liveLock.availablePermits() == 0;
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void releaseBackup() {
        if (this.backupLock != null) {
            this.backupLock.release();
        }
    }

    @Override
    public SimpleString readNodeId() throws ActiveMQIllegalStateException, IOException {
        return this.getNodeId();
    }

    public static enum State {
        LIVE,
        PAUSED,
        FAILING_BACK,
        NOT_STARTED;

    }
}

