/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityStore;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class JPAStoreSubsystemConfiguration
extends JPAIdentityStoreConfiguration {
    private final Module entityModule;
    private final String dataSourceJndiUrl;
    private final String entityManagerFactoryJndiName;
    private String entityModuleUnitName = "identity";

    JPAStoreSubsystemConfiguration(String entityModuleName, String entityModuleUnitName, String dataSourceJndiUrl, String entityManagerFactoryJndiName, Set<Class<?>> entityTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, Set<Class<? extends CredentialHandler>> credentialHandlers, boolean supportsAttribute, boolean supportsCredential, boolean supportsPermissions) throws SecurityConfigurationException {
        super(entityTypes, supportedTypes, unsupportedTypes, contextInitializers, credentialHandlerProperties, credentialHandlers, supportsAttribute, supportsCredential, supportsPermissions);
        if (entityModuleName != null) {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            try {
                this.entityModule = moduleLoader.loadModule(ModuleIdentifier.fromString((String)entityModuleName));
            }
            catch (ModuleLoadException e) {
                throw PicketLinkLogger.ROOT_LOGGER.idmJpaEntityModuleNotFound(entityModuleName);
            }
        } else {
            this.entityModule = null;
        }
        if (entityModuleUnitName != null) {
            this.entityModuleUnitName = entityModuleUnitName;
        }
        this.dataSourceJndiUrl = dataSourceJndiUrl;
        this.entityManagerFactoryJndiName = entityManagerFactoryJndiName;
    }

    public Class<? extends IdentityStore> getIdentityStoreType() {
        return JPAIdentityStore.class;
    }

    public Module getEntityModule() {
        return this.entityModule;
    }

    public String getDataSourceJndiUrl() {
        return this.dataSourceJndiUrl;
    }

    public String getEntityModuleUnitName() {
        return this.entityModuleUnitName;
    }

    public String getEntityManagerFactoryJndiName() {
        return this.entityManagerFactoryJndiName;
    }
}

