/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.server.SystemExiter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class HostShutdownHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "shutdown";
    private final DomainController domainController;
    private static final AttributeDefinition RESTART = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"restart", (ModelType)ModelType.BOOLEAN, (boolean)true).setRequired(false)).build();
    private static final AttributeDefinition SUSPEND_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"suspend-timeout", (ModelType)ModelType.INT, (boolean)true).setMeasurementUnit(MeasurementUnit.SECONDS)).setDefaultValue(new ModelNode(0))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("shutdown", HostResolver.getResolver("host")).addParameter(RESTART).addParameter(SUSPEND_TIMEOUT).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly().build();
    private final ServerInventory serverInventory;

    public HostShutdownHandler(DomainController domainController, ServerInventory serverInventory) {
        this.domainController = domainController;
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean restart = RESTART.validateOperation(operation).asBoolean(false);
        final Resource hostResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final int suspendTimeout = SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
        final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                AuthorizationResult authorizationResult = context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                    throw ControllerLogger.ACCESS_LOGGER.unauthorized(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address")), authorizationResult.getExplanation());
                }
                Set<String> servers = HostShutdownHandler.this.getServersForHost(hostResource);
                List<ModelNode> errorResponses = HostShutdownHandler.this.serverInventory.suspendServers(servers, suspendTimeout, blockingTimeout);
                if (!errorResponses.isEmpty()) {
                    context.getFailureDescription().set(errorResponses);
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, final ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            SystemExiter.logBeforeExit((SystemExiter.ExitLogger)new SystemExiter.ExitLogger(){

                                public void logExit() {
                                    HostControllerLogger.ROOT_LOGGER.shuttingDownInResponseToManagementRequest(HostShutdownHandler.getOperationName(operation));
                                }
                            });
                            if (restart) {
                                HostShutdownHandler.this.domainController.stopLocalHost(10);
                            } else {
                                HostShutdownHandler.this.domainController.stopLocalHost();
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    Set<String> getServersForHost(Resource hostResource) {
        HashSet<String> servers = new HashSet<String>();
        ModelNode hostModel = Resource.Tools.readModel((Resource)hostResource);
        ModelNode serverConfig = hostModel.get("server-config");
        if (serverConfig.isDefined()) {
            for (Property config : serverConfig.asPropertyList()) {
                servers.add(config.getName());
            }
        }
        return servers;
    }

    private static String getOperationName(ModelNode op) {
        return op.hasDefined("operation") ? op.get("operation").asString() : OPERATION_NAME;
    }
}

