/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.TransactionManager;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class InboundBridge {
    private final Xid xid;

    InboundBridge(Xid xid) throws XAException, SystemException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.<ctor>(Xid=" + xid + ")"));
        this.xid = xid;
        this.getTransaction();
    }

    public Xid getXid() {
        return this.xid;
    }

    public void start() throws XAException, SystemException, InvalidTransactionException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.start(Xid=" + this.xid + ")"));
        Transaction tx = this.getTransaction();
        TransactionManager.transactionManager().resume(tx);
    }

    public void stop() throws XAException, SystemException, InvalidTransactionException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.stop(" + this.xid + ")"));
        TransactionManager.transactionManager().suspend();
    }

    public void setRollbackOnly() throws XAException, SystemException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.setRollbackOnly(" + this.xid + ")"));
        this.getTransaction().setRollbackOnly();
    }

    private Transaction getTransaction() throws XAException, SystemException {
        SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(this.xid);
        switch (tx.getStatus()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Transaction not in state ACTIVE");
            }
        }
        return tx;
    }
}

