/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PermissionTicketEntity;
import org.keycloak.authorization.jpa.store.PermissionTicketAdapter;
import org.keycloak.authorization.jpa.store.ResourceAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.jpa.store.ScopeAdapter;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAPermissionTicketStore
implements PermissionTicketStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAPermissionTicketStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public PermissionTicket create(String resourceId, String scopeId, String requester, ResourceServer resourceServer) {
        PermissionTicketEntity entity = new PermissionTicketEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setResource(ResourceAdapter.toEntity(this.entityManager, this.provider.getStoreFactory().getResourceStore().findById(resourceId, resourceServer.getId())));
        entity.setRequester(requester);
        entity.setCreatedTimestamp(System.currentTimeMillis());
        if (scopeId != null) {
            entity.setScope(ScopeAdapter.toEntity(this.entityManager, this.provider.getStoreFactory().getScopeStore().findById(scopeId, resourceServer.getId())));
        }
        entity.setOwner(entity.getResource().getOwner());
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        PermissionTicketAdapter model = new PermissionTicketAdapter(entity, this.entityManager, this.provider.getStoreFactory());
        return model;
    }

    public void delete(String id) {
        PermissionTicketEntity policy = (PermissionTicketEntity)this.entityManager.find(PermissionTicketEntity.class, (Object)id);
        if (policy != null) {
            this.entityManager.remove((Object)policy);
        }
    }

    public PermissionTicket findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        PermissionTicketEntity entity = (PermissionTicketEntity)this.entityManager.find(PermissionTicketEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new PermissionTicketAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public List<PermissionTicket> findByResourceServer(String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(id, resourceServerId);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> findByResource(String resourceId, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPermissionIdByResource", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(id, resourceServerId);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> findByScope(String scopeId, String resourceServerId) {
        if (scopeId == null) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPermissionIdByScope", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeId", (Object)scopeId);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(id, resourceServerId);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> find(Map<String, String> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(PermissionTicketEntity.class);
        Root root = querybuilder.from(PermissionTicketEntity.class);
        querybuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (resourceServerId != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        }
        attributes.forEach((name, value) -> {
            if ("id".equals(name)) {
                predicates.add(root.get(name).in(new Object[]{value}));
            } else if ("scope.id".equals(name)) {
                predicates.add(root.join("scope").get("id").in(new Object[]{value}));
            } else if ("scope_is_null".equals(name)) {
                if (Boolean.valueOf(value).booleanValue()) {
                    predicates.add(builder.isNull((Expression)root.get("scope")));
                } else {
                    predicates.add(builder.isNotNull((Expression)root.get("scope")));
                }
            } else if ("resource.id".equals(name)) {
                predicates.add(root.join("resource").get("id").in(new Object[]{value}));
            } else if ("resource.name".equals(name)) {
                predicates.add(root.join("resource").get("name").in(new Object[]{value}));
            } else if ("owner".equals(name)) {
                predicates.add(builder.equal((Expression)root.get("owner"), value));
            } else if ("requester".equals(name)) {
                predicates.add(builder.equal((Expression)root.get("requester"), value));
            } else if ("granted".equals(name)) {
                if (Boolean.valueOf(value).booleanValue()) {
                    predicates.add(builder.isNotNull((Expression)root.get("grantedTimestamp")));
                } else {
                    predicates.add(builder.isNull((Expression)root.get("grantedTimestamp")));
                }
            } else if ("requester_is_null".equals(name)) {
                predicates.add(builder.isNull((Expression)root.get("requester")));
            } else if ("policy_is_not_null".equals(name)) {
                predicates.add(builder.isNotNull((Expression)root.get("policy")));
            } else if ("policy".equals(name)) {
                predicates.add(root.join("policy").get("id").in(new Object[]{value}));
            } else {
                throw new RuntimeException("Unsupported filter [" + name + "]");
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("resource").get("id"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(id, resourceServerId);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> findGranted(String userId, String resourceServerId) {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("granted", Boolean.TRUE.toString());
        filters.put("requester", userId);
        return this.find(filters, resourceServerId, -1, -1);
    }

    public List<PermissionTicket> findGranted(String resourceName, String userId, String resourceServerId) {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("resource.name", resourceName);
        filters.put("granted", Boolean.TRUE.toString());
        filters.put("requester", userId);
        return this.find(filters, resourceServerId, -1, -1);
    }

    public List<PermissionTicket> findByOwner(String owner, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByType", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("owner", (Object)owner);
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(id, resourceServerId);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }
}

