/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class JsonMetadataExporter
implements Exporter {
    private static final Map<String, ?> JSON_CONFIG = new HashMap<String, Object>(){
        {
            this.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
    };

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public StringBuffer exportOneScope(MetricRegistry.Type scope) {
        MetricRegistry registry = MetricRegistries.get(scope);
        if (registry == null) {
            return null;
        }
        JsonObject obj = this.registryJSON(registry);
        return this.stringify(obj);
    }

    @Override
    public StringBuffer exportAllScopes() {
        JsonObject obj = this.rootJSON();
        return this.stringify(obj);
    }

    @Override
    public StringBuffer exportOneMetric(MetricRegistry.Type scope, String metricName) {
        MetricRegistry registry = MetricRegistries.get(scope);
        if (registry == null) {
            return null;
        }
        Metadata metric = (Metadata)registry.getMetadata().get(metricName);
        if (metric == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.metricJSON(builder, metricName, metric);
        return this.stringify(builder.build());
    }

    StringBuffer stringify(JsonObject obj) {
        StringWriter out = new StringWriter();
        try (JsonWriter writer = Json.createWriterFactory(JSON_CONFIG).createWriter((Writer)out);){
            writer.writeObject(obj);
        }
        return out.getBuffer();
    }

    private JsonObject rootJSON() {
        JsonObjectBuilder root = Json.createObjectBuilder();
        root.add("base", (JsonValue)this.registryJSON(MetricRegistries.get(MetricRegistry.Type.BASE)));
        root.add("vendor", (JsonValue)this.registryJSON(MetricRegistries.get(MetricRegistry.Type.VENDOR)));
        root.add("application", (JsonValue)this.registryJSON(MetricRegistries.get(MetricRegistry.Type.APPLICATION)));
        return root.build();
    }

    private JsonObject registryJSON(MetricRegistry registry) {
        JsonObjectBuilder registryJSON = Json.createObjectBuilder();
        Map metrics = registry.getMetadata();
        metrics.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> this.metricJSON(registryJSON, (String)e.getKey(), (Metadata)e.getValue()));
        return registryJSON.build();
    }

    private void metricJSON(JsonObjectBuilder registryJSON, String name, Metadata metric) {
        registryJSON.add(name, (JsonValue)this.metricJSON(metric));
    }

    private JsonObject metricJSON(Metadata metadata) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        if (metadata.getUnit() != null) {
            obj.add("unit", metadata.getUnit());
        }
        if (metadata.getType() != null) {
            obj.add("type", metadata.getType());
        }
        if (metadata.getDescription() != null) {
            obj.add("description", metadata.getDescription());
        }
        if (metadata.getDisplayName() != null) {
            obj.add("displayName", metadata.getDisplayName());
        }
        if (metadata.getTagsAsString() != null) {
            String str = metadata.getTags().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
            obj.add("tags", str);
        }
        return obj.build();
    }
}

