/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.IdentifierSerializerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum SessionIdentifierSerializer implements Serializer<String>
{
    INSTANCE;

    private final Serializer<String> serializer = (Serializer)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Serializer<String>>(){

        @Override
        public Serializer<String> run() {
            Iterator<IdentifierSerializerProvider> providerIterator = ServiceLoader.load(IdentifierSerializerProvider.class, IdentifierSerializerProvider.class.getClassLoader()).iterator();
            if (!providerIterator.hasNext()) {
                throw new IllegalStateException();
            }
            return providerIterator.next().getSerializer();
        }
    });

    public void write(DataOutput output, String value) throws IOException {
        this.serializer.write(output, (Object)value);
    }

    public String read(DataInput input) throws IOException {
        return (String)this.serializer.read(input);
    }
}

