/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BrowserSecurityHeaders {
    public static final Map<String, String> headerAttributeMap;
    public static final Map<String, String> defaultHeaders;

    static {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("xFrameOptions", "X-Frame-Options");
        headerMap.put("contentSecurityPolicy", "Content-Security-Policy");
        headerMap.put("contentSecurityPolicyReportOnly", "Content-Security-Policy-Report-Only");
        headerMap.put("xContentTypeOptions", "X-Content-Type-Options");
        headerMap.put("xRobotsTag", "X-Robots-Tag");
        headerMap.put("xXSSProtection", "X-XSS-Protection");
        headerMap.put("strictTransportSecurity", "Strict-Transport-Security");
        HashMap<String, String> dh = new HashMap<String, String>();
        dh.put("xFrameOptions", "SAMEORIGIN");
        dh.put("contentSecurityPolicy", "frame-src 'self'; frame-ancestors 'self'; object-src 'none';");
        dh.put("contentSecurityPolicyReportOnly", "");
        dh.put("xContentTypeOptions", "nosniff");
        dh.put("xRobotsTag", "none");
        dh.put("xXSSProtection", "1; mode=block");
        dh.put("strictTransportSecurity", "max-age=31536000; includeSubDomains");
        defaultHeaders = Collections.unmodifiableMap(dh);
        headerAttributeMap = Collections.unmodifiableMap(headerMap);
    }
}

