/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetSystemPropertyAsBooleanAction;
import org.infinispan.security.actions.GetSystemPropertyAsIntegerAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static boolean getBooleanProperty(String name) {
        return SecurityActions.doPrivileged(new GetSystemPropertyAsBooleanAction(name));
    }

    static int getIntProperty(String name, int defaultValue) {
        return SecurityActions.doPrivileged(new GetSystemPropertyAsIntegerAction(name, defaultValue));
    }
}

