/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.util.EnumMap;
import java.util.EnumSet;

public class Attributes {
    private final EnumSet<InputFlag> inputFlags = EnumSet.noneOf(InputFlag.class);
    private final EnumSet<OutputFlag> outputFlags = EnumSet.noneOf(OutputFlag.class);
    private final EnumSet<ControlFlag> controlFlags = EnumSet.noneOf(ControlFlag.class);
    private final EnumSet<LocalFlag> localFlags = EnumSet.noneOf(LocalFlag.class);
    private final EnumMap<ControlChar, Integer> controlChars = new EnumMap(ControlChar.class);

    public Attributes() {
    }

    public Attributes(Attributes attr) {
        this.copy(attr);
    }

    public EnumSet<InputFlag> getInputFlags() {
        return this.inputFlags;
    }

    public void setInputFlags(EnumSet<InputFlag> flags) {
        this.inputFlags.clear();
        this.inputFlags.addAll(flags);
    }

    public boolean getInputFlag(InputFlag flag) {
        return this.inputFlags.contains((Object)flag);
    }

    public void setInputFlags(EnumSet<InputFlag> flags, boolean value) {
        if (value) {
            this.inputFlags.addAll(flags);
        } else {
            this.inputFlags.removeAll(flags);
        }
    }

    public void setInputFlag(InputFlag flag, boolean value) {
        if (value) {
            this.inputFlags.add(flag);
        } else {
            this.inputFlags.remove((Object)flag);
        }
    }

    public EnumSet<OutputFlag> getOutputFlags() {
        return this.outputFlags;
    }

    public void setOutputFlags(EnumSet<OutputFlag> flags) {
        this.outputFlags.clear();
        this.outputFlags.addAll(flags);
    }

    public boolean getOutputFlag(OutputFlag flag) {
        return this.outputFlags.contains((Object)flag);
    }

    public void setOutputFlags(EnumSet<OutputFlag> flags, boolean value) {
        if (value) {
            this.outputFlags.addAll(flags);
        } else {
            this.outputFlags.removeAll(flags);
        }
    }

    public void setOutputFlag(OutputFlag flag, boolean value) {
        if (value) {
            this.outputFlags.add(flag);
        } else {
            this.outputFlags.remove((Object)flag);
        }
    }

    public EnumSet<ControlFlag> getControlFlags() {
        return this.controlFlags;
    }

    public void setControlFlags(EnumSet<ControlFlag> flags) {
        this.controlFlags.clear();
        this.controlFlags.addAll(flags);
    }

    public boolean getControlFlag(ControlFlag flag) {
        return this.controlFlags.contains((Object)flag);
    }

    public void setControlFlags(EnumSet<ControlFlag> flags, boolean value) {
        if (value) {
            this.controlFlags.addAll(flags);
        } else {
            this.controlFlags.removeAll(flags);
        }
    }

    public void setControlFlag(ControlFlag flag, boolean value) {
        if (value) {
            this.controlFlags.add(flag);
        } else {
            this.controlFlags.remove((Object)flag);
        }
    }

    public EnumSet<LocalFlag> getLocalFlags() {
        return this.localFlags;
    }

    public void setLocalFlags(EnumSet<LocalFlag> flags) {
        this.localFlags.clear();
        this.localFlags.addAll(flags);
    }

    public boolean getLocalFlag(LocalFlag flag) {
        return this.localFlags.contains((Object)flag);
    }

    public void setLocalFlags(EnumSet<LocalFlag> flags, boolean value) {
        if (value) {
            this.localFlags.addAll(flags);
        } else {
            this.localFlags.removeAll(flags);
        }
    }

    public void setLocalFlag(LocalFlag flag, boolean value) {
        if (value) {
            this.localFlags.add(flag);
        } else {
            this.localFlags.remove((Object)flag);
        }
    }

    public EnumMap<ControlChar, Integer> getControlChars() {
        return this.controlChars;
    }

    public void setControlChars(EnumMap<ControlChar, Integer> chars) {
        this.controlChars.clear();
        this.controlChars.putAll(chars);
    }

    public int getControlChar(ControlChar c) {
        return this.controlChars.getOrDefault((Object)c, -1);
    }

    public void setControlChar(ControlChar c, int value) {
        this.controlChars.put(c, value);
    }

    public void copy(Attributes attributes) {
        this.setControlFlags(attributes.getControlFlags());
        this.setInputFlags(attributes.getInputFlags());
        this.setLocalFlags(attributes.getLocalFlags());
        this.setOutputFlags(attributes.getOutputFlags());
        this.setControlChars(attributes.getControlChars());
    }

    public static enum LocalFlag {
        ECHOKE,
        ECHOE,
        ECHOK,
        ECHO,
        ECHONL,
        ECHOPRT,
        ECHOCTL,
        ISIG,
        ICANON,
        ALTWERASE,
        IEXTEN,
        EXTPROC,
        TOSTOP,
        FLUSHO,
        NOKERNINFO,
        PENDIN,
        NOFLSH;

    }

    public static enum ControlFlag {
        CIGNORE,
        CS5,
        CS6,
        CS7,
        CS8,
        CSTOPB,
        CREAD,
        PARENB,
        PARODD,
        HUPCL,
        CLOCAL,
        CCTS_OFLOW,
        CRTS_IFLOW,
        CDTR_IFLOW,
        CDSR_OFLOW,
        CCAR_OFLOW;

    }

    public static enum OutputFlag {
        OPOST,
        ONLCR,
        OXTABS,
        ONOEOT,
        OCRNL,
        ONOCR,
        ONLRET,
        OFILL,
        NLDLY,
        TABDLY,
        CRDLY,
        FFDLY,
        BSDLY,
        VTDLY,
        OFDEL;

    }

    public static enum InputFlag {
        IGNBRK,
        BRKINT,
        IGNPAR,
        PARMRK,
        INPCK,
        ISTRIP,
        INLCR,
        IGNCR,
        ICRNL,
        IXON,
        IXOFF,
        IXANY,
        IMAXBEL,
        IUTF8;

    }

    public static enum ControlChar {
        VEOF,
        VEOL,
        VEOL2,
        VERASE,
        VWERASE,
        VKILL,
        VREPRINT,
        VINTR,
        VQUIT,
        VSUSP,
        VDSUSP,
        VSTART,
        VSTOP,
        VLNEXT,
        VDISCARD,
        VMIN,
        VTIME,
        VSTATUS;

    }
}

