/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.infinispan.client.InfinispanClientRequirement;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagementConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionManagerNearCacheFactory;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class HotRodSessionManagerFactoryServiceConfigurator<C extends Marshallability, L>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
HotRodSessionManagerFactoryConfiguration<C, L>,
Supplier<SessionManagerFactory<L, TransactionBatch>> {
    private final HotRodSessionManagementConfiguration configuration;
    private final SessionManagerFactoryConfiguration<C, L> factoryConfiguration;
    private volatile SupplierDependency<RemoteCacheContainer> container;

    public HotRodSessionManagerFactoryServiceConfigurator(HotRodSessionManagementConfiguration configuration, SessionManagerFactoryConfiguration<C, L> factoryConfiguration) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "web", factoryConfiguration.getDeploymentName()}));
        this.configuration = configuration;
        this.factoryConfiguration = factoryConfiguration;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        String containerName = this.configuration.getContainerName();
        this.container = new ServiceSupplierDependency(InfinispanClientRequirement.REMOTE_CONTAINER.getServiceName(support, containerName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = this.container.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public SessionManagerFactory<L, TransactionBatch> get() {
        return new HotRodSessionManagerFactory(this);
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.configuration.getAttributePersistenceStrategy();
    }

    @Override
    public String getContainerName() {
        return this.configuration.getContainerName();
    }

    @Override
    public String getConfigurationName() {
        return this.configuration.getConfigurationName();
    }

    public Integer getMaxActiveSessions() {
        return this.factoryConfiguration.getMaxActiveSessions();
    }

    public MarshalledValueFactory<C> getMarshalledValueFactory() {
        return this.factoryConfiguration.getMarshalledValueFactory();
    }

    public C getMarshallingContext() {
        return (C)this.factoryConfiguration.getMarshallingContext();
    }

    public LocalContextFactory<L> getLocalContextFactory() {
        return this.factoryConfiguration.getLocalContextFactory();
    }

    public String getServerName() {
        return this.factoryConfiguration.getServerName();
    }

    public String getDeploymentName() {
        return this.factoryConfiguration.getDeploymentName();
    }

    public Immutability getImmutability() {
        return this.factoryConfiguration.getImmutability();
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache() {
        RemoteCacheContainer container = (RemoteCacheContainer)this.container.get();
        String cacheName = this.getDeploymentName();
        try (RemoteCacheContainer.NearCacheRegistration registration = container.registerNearCacheFactory(cacheName, new SessionManagerNearCacheFactory(this.getMaxActiveSessions(), this.getAttributePersistenceStrategy()));){
            RemoteCache remoteCache = ((RemoteCacheContainer)this.container.get()).administration().getOrCreateCache(cacheName, this.getConfigurationName());
            return remoteCache;
        }
    }
}

