/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.utils.DefaultSensitiveStringCodec;
import org.hornetq.utils.HornetQUtilBundle;
import org.hornetq.utils.SensitiveDataCodec;

public class PasswordMaskingUtil {
    public static SensitiveDataCodec<String> getCodec(String codecDesc) throws HornetQException {
        SensitiveDataCodec<String> codecInstance = null;
        String[] parts = codecDesc.split(";");
        if (parts.length < 1) {
            throw new HornetQException(HornetQExceptionType.ILLEGAL_STATE, "Invalid PasswordCodec value: " + codecDesc);
        }
        final String codecClassName = parts[0];
        codecInstance = AccessController.doPrivileged(new PrivilegedAction<SensitiveDataCodec<String>>(){

            @Override
            public SensitiveDataCodec<String> run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(codecClassName);
                    return (SensitiveDataCodec)clazz.newInstance();
                }
                catch (Exception e) {
                    throw HornetQUtilBundle.BUNDLE.errorCreatingCodec(e, codecClassName);
                }
            }
        });
        if (parts.length > 1) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String[] keyVal = parts[i].split("=");
                if (keyVal.length != 2) {
                    throw HornetQUtilBundle.BUNDLE.invalidProperty(parts[i]);
                }
                props.put(keyVal[0], keyVal[1]);
            }
            codecInstance.init(props);
        }
        return codecInstance;
    }

    public static SensitiveDataCodec<String> getDefaultCodec() {
        return new DefaultSensitiveStringCodec();
    }
}

