/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query;

import java.io.UnsupportedEncodingException;

public enum EscapeStrategy {
    NON_ASCII_CHARS_ONLY{

        @Override
        public String escape(String input) {
            try {
                StringBuilder output = new StringBuilder();
                for (byte b : input.getBytes("UTF-8")) {
                    this.appendByte(b, output);
                }
                return output.toString();
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public String escape(String input) {
            try {
                StringBuilder output = new StringBuilder();
                block9: for (byte b : input.getBytes("UTF-8")) {
                    switch (b) {
                        case 92: {
                            output.append("\\5c");
                            continue block9;
                        }
                        case 42: {
                            output.append("\\2a");
                            continue block9;
                        }
                        case 40: {
                            output.append("\\28");
                            continue block9;
                        }
                        case 41: {
                            output.append("\\29");
                            continue block9;
                        }
                        case 0: {
                            output.append("\\00");
                            continue block9;
                        }
                        default: {
                            this.appendByte(b, output);
                        }
                    }
                }
                return output.toString();
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }
    }
    ,
    OCTET_STRING{

        @Override
        public String escape(String input) {
            byte[] bytes;
            try {
                bytes = input.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return 3.escapeHex(bytes);
        }
    };


    public static String escapeHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("\\%02x", b));
        }
        return sb.toString();
    }

    public abstract String escape(String var1);

    protected void appendByte(byte b, StringBuilder output) {
        if (b >= 0) {
            output.append((char)b);
        } else {
            int i = 0xFFFFFF00 ^ b;
            output.append("\\").append(Integer.toHexString(i));
        }
    }
}

